/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.project.strategy.custom;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.exception.ServiceException;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.common.math.MathUtil;
import com.digiwin.mobile.mobileuibot.core.component.divider.Divider;
import com.digiwin.mobile.mobileuibot.core.component.divider.DividerTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.navbar.pagedesc.PageDescBuilderFactory;
import com.digiwin.mobile.mobileuibot.core.component.progress.ProgressRate;
import com.digiwin.mobile.mobileuibot.core.component.progress.ProgressRateTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtab.CustomTabs;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtab.CustomTabsBuilder;
import com.digiwin.mobile.mobileuibot.core.component.title.titlebody.TitleBody;
import com.digiwin.mobile.mobileuibot.core.component.title.titledesc.TitleDesc;
import com.digiwin.mobile.mobileuibot.core.component.title.titledesc.TitleDescProjectCCBuilder;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.project.strategy.ProjectDetailBuildStrategy;
import com.digiwin.mobile.mobileuibot.proxy.atdm.model.pcc.PccApiDataWrapper;
import com.digiwin.mobile.mobileuibot.proxy.atdm.model.pcc.PccProjectInfo;
import com.digiwin.mobile.mobileuibot.proxy.atdm.model.pcc.PccProjectTaskInfo;
import com.digiwin.mobile.mobileuibot.proxy.atdm.service.DigiwinAtdmProxyService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcPanel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;

@Component(value="projectDetailBuildProjectCCStrategy")
public class ProjectDetailBuildProjectCCStrategy
implements ProjectDetailBuildStrategy {
    private static final Logger logger = LoggerFactory.getLogger(ProjectDetailBuildProjectCCStrategy.class);
    @Resource(name="defaultThreadPool")
    private ThreadPoolTaskExecutor threadPoolTaskExecutor;
    @Autowired
    private DigiwinAtdmProxyService digiwinAtdmProxyService;
    @Autowired
    private TitleDescProjectCCBuilder titleDescProjectCCBuilder;
    @Autowired
    private CustomTabsBuilder customTabsBuilder;
    @Autowired
    private PageDescBuilderFactory pageDescBuilderFactory;

    public String getProjectDetailType() {
        return "task_Project_Center_Console_progressTrack";
    }

    public Map<String, Object> build(ApiRequest apiRequest, String iamUserToken, PageSetting pageSetting, UiBotModel pcUiBotModel, DigiwinAtmcPanel digiwinAtmcPanel, Object ... args) {
        String locale = apiRequest.getLocale();
        String tenantId = apiRequest.getTenantId();
        StopWatch stopWatch = new StopWatch("Build Project-Detail Page Data");
        stopWatch.start("Get ProjectCC Detail Data From Athena ATDM");
        ArrayList<Future> futureList = new ArrayList<Future>();
        Future futureAtdmProjectInfo = this.threadPoolTaskExecutor.submit(this.buildGetProjectInfoCallable(locale, iamUserToken, pcUiBotModel, this.digiwinAtdmProxyService, tenantId));
        futureList.add(futureAtdmProjectInfo);
        Future futureAtdmProjectTaskInfo = this.threadPoolTaskExecutor.submit(this.buildGetProjectTaskInfoCallable(locale, iamUserToken, pcUiBotModel, this.digiwinAtdmProxyService, tenantId));
        futureList.add(futureAtdmProjectTaskInfo);
        PccApiDataWrapper projectInfo = null;
        PccApiDataWrapper projectTaskInfo = null;
        try {
            block6: for (Future future : futureList) {
                while (true) {
                    if (future.isDone() && !future.isCancelled()) {
                        PccApiDataWrapper container;
                        Object obj = future.get();
                        if (!(obj instanceof PccApiDataWrapper) || null == (container = (PccApiDataWrapper)obj).getProjectInfoList() || container.getProjectInfoList().isEmpty()) continue block6;
                        Object firstEle = container.getProjectInfoList().get(0);
                        if (firstEle instanceof PccProjectInfo) {
                            projectInfo = container;
                            continue block6;
                        }
                        if (!(firstEle instanceof PccProjectTaskInfo)) continue block6;
                        projectTaskInfo = container;
                        continue block6;
                    }
                    Thread.sleep(1L);
                }
            }
        }
        catch (InterruptedException | ExecutionException e) {
            logger.error(e.getLocalizedMessage());
            e.printStackTrace();
            String message = e.getMessage();
            if (null != e.getCause()) {
                message = e.getCause().getMessage();
            }
            throw new ServiceException(message);
        }
        stopWatch.stop();
        if (null == projectInfo || CollectionUtils.isEmpty((Collection)projectInfo.getProjectInfoList())) {
            return Collections.emptyMap();
        }
        stopWatch.start("Add Data to ProjectCC PageModel");
        HashMap<String, Object> result = new HashMap<String, Object>();
        PccProjectInfo pccProjectInfo = (PccProjectInfo)projectInfo.getProjectInfoList().get(0);
        UiBotModel pageModel = pageSetting.getPageModel();
        Iterator layoutIterator = pageModel.getLayout().iterator();
        while (layoutIterator.hasNext()) {
            UiBotLayout layout = (UiBotLayout)layoutIterator.next();
            String schema = layout.getSchema();
            if (layout.getType().equalsIgnoreCase("TITLE_DESC")) {
                result.put(schema, this.titleDescProjectCCBuilder.build(apiRequest, pageSetting, pcUiBotModel, TitleDesc.class, new Object[]{pccProjectInfo, digiwinAtmcPanel}));
                continue;
            }
            if (layout.getType().equalsIgnoreCase("TITLE_BODY")) {
                result.put(schema, TitleBody.create((ApiRequest)apiRequest, (PageSetting)pageSetting, (UiBotModel)pcUiBotModel, (PccProjectInfo)pccProjectInfo, (DigiwinAtmcPanel)digiwinAtmcPanel, (PageDescBuilderFactory)this.pageDescBuilderFactory));
                continue;
            }
            if (layout.getType().equalsIgnoreCase("PROGRESS_RATE")) {
                if ("progressRateFinished".equalsIgnoreCase(schema)) {
                    double rate = MathUtil.getDecimalPoint((double)Optional.ofNullable(pccProjectInfo.getProjectCompleteRate()).orElse(0.0), (int)2);
                    result.put(schema, new ProgressRate(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u5b8c\u6210\u7387") + String.format("%.0f", rate * 100.0) + "%", ProgressRateTypeEnum.NORMAL.getType(), Double.valueOf(rate)));
                    continue;
                }
                if ("progressRateOverdue".equalsIgnoreCase(schema)) {
                    double rate = MathUtil.getDecimalPoint((double)Optional.ofNullable(pccProjectInfo.getProjectOverdueRate()).orElse(0.0), (int)2);
                    if (rate != 0.0) {
                        result.put(schema, new ProgressRate(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u903e\u671f\u7387") + String.format("%.0f", rate * 100.0) + "%", ProgressRateTypeEnum.EXCEPTION.getType(), Double.valueOf(rate)));
                        continue;
                    }
                    layoutIterator.remove();
                    continue;
                }
                result.put(schema, new ProgressRate(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u672a\u5b9a\u4e49"), ProgressRateTypeEnum.NORMAL.getType(), Double.valueOf(0.0)));
                continue;
            }
            if (layout.getType().equalsIgnoreCase("DIVIDER")) {
                Divider divider = Divider.create((DividerTypeEnum)DividerTypeEnum.BLOCK_DIVIDER);
                String newSchema = schema + "_" + divider.getCmptUuid();
                layout.setSchema(newSchema);
                result.put(newSchema, divider);
                continue;
            }
            if (!layout.getType().equalsIgnoreCase(this.customTabsBuilder.getMobileComponentType()) || projectTaskInfo == null) continue;
            List pccProjectTaskInfo = projectTaskInfo.getProjectInfoList();
            CustomTabs customTabs = this.customTabsBuilder.build(apiRequest, pageSetting, pcUiBotModel, CustomTabs.class, new Object[]{layout, pccProjectTaskInfo, pccProjectInfo.getProjectNo(), apiRequest.getTenantId()});
            result.put(schema, customTabs);
        }
        stopWatch.stop();
        result.put("project_info", pccProjectInfo);
        logger.debug(stopWatch.prettyPrint());
        return result;
    }

    private Callable<PccApiDataWrapper<PccProjectInfo>> buildGetProjectInfoCallable(String locale, String iamUserToken, UiBotModel pcUiBotModel, DigiwinAtdmProxyService digiwinAtdmProxyService, String tenantId) {
        return () -> {
            HashMap<String, Object> bodyPayloadMap = new HashMap<String, Object>(4);
            String actionId = "project.info.get";
            bodyPayloadMap.put("actionId", actionId);
            bodyPayloadMap.put("businessUnit", pcUiBotModel.getExecuteContext().get((Object)"businessUnit"));
            Map taskWithBacklogData = (Map)pcUiBotModel.getExecuteContext().get((Object)"taskWithBacklogData");
            Map bpmData = (Map)taskWithBacklogData.get("bpmData");
            List projectDataList = (List)bpmData.get("project_data");
            HashMap<String, List> parameter = new HashMap<String, List>(1);
            parameter.put("project_info", projectDataList);
            bodyPayloadMap.put("parameter", parameter);
            return digiwinAtdmProxyService.dataQueryByActionProjectInfo(locale, iamUserToken, JsonUtil.javaObjectToJsonString(bodyPayloadMap), tenantId);
        };
    }

    private Callable<PccApiDataWrapper<PccProjectTaskInfo>> buildGetProjectTaskInfoCallable(String locale, String iamUserToken, UiBotModel pcUiBotModel, DigiwinAtdmProxyService digiwinAtdmProxyService, String tenantId) {
        return () -> {
            HashMap<String, Object> bodyPayloadMap = new HashMap<String, Object>(4);
            String actionId = "task.info.get";
            bodyPayloadMap.put("actionId", actionId);
            bodyPayloadMap.put("businessUnit", pcUiBotModel.getExecuteContext().get((Object)"businessUnit"));
            Map taskWithBacklogData = (Map)pcUiBotModel.getExecuteContext().get((Object)"taskWithBacklogData");
            Map bpmData = (Map)taskWithBacklogData.get("bpmData");
            List projectDataList = (List)bpmData.get("project_data");
            if (null != projectDataList && !projectDataList.isEmpty()) {
                ((Map)projectDataList.get(0)).put("control_mode", "1");
            }
            HashMap<String, List> parameter = new HashMap<String, List>(1);
            parameter.put("project_info", projectDataList);
            bodyPayloadMap.put("parameter", parameter);
            return digiwinAtdmProxyService.dataQueryByActionProjectTaskInfo(locale, iamUserToken, JsonUtil.javaObjectToJsonString(bodyPayloadMap), tenantId);
        };
    }
}

