/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.proxy.uibot.model.agiledata;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.annotation.JSONField;
import com.digiwin.mobile.mobileuibot.core.component.chart.ChartTypeEnum;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.agiledata.AgileDataIntermediateDataItem;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.agiledata.AgileDataRenderGraph;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.agiledata.AgileDataShowCategoryEnum;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.agiledata.WebDynamicLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.agiledata.WebGridsterLayoutDashboard;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.agiledata.chart.ChartRenderSetting;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;

public class AgileDataIntermediateLayout
implements Serializable {
    private static final long serialVersionUID = 1719944742293640765L;
    private String type;
    private String generateTime;
    private List<AgileDataIntermediateDataItem> data;
    private String dataConclusion;
    private AgileDataRenderGraph renderGraph;
    private List<WebDynamicLayout> dynamicLayout;
    @JsonIgnore
    @JSONField(serialize=false)
    private List<AgileDataIntermediateDataItem> sortedDataItems;

    public void init() {
        this.sort();
        this.checkChartType();
    }

    private void sort() {
        if (CollectionUtil.isEmpty((Collection)this.data)) {
            this.sortedDataItems = Collections.emptyList();
        }
        if (CollectionUtil.isEmpty((Collection)this.dynamicLayout)) {
            this.sortedDataItems = this.data;
            return;
        }
        WebDynamicLayout dynamicLayout = (WebDynamicLayout)this.dynamicLayout.get(0);
        if (!Objects.equals(dynamicLayout.getType(), "GRIDSTER")) {
            this.sortedDataItems = this.data;
        }
        if (CollectionUtil.isEmpty((Collection)dynamicLayout.getItems())) {
            this.sortedDataItems = this.data;
        }
        List<String> dashboardLayoutBizIds = dynamicLayout.getItems().stream().sorted((o1, o2) -> {
            Integer x1 = o1.getX();
            Integer y1 = o1.getY();
            Integer x2 = o2.getX();
            Integer y2 = o2.getY();
            if (Objects.equals(y1, y2)) {
                return x1.compareTo(x2);
            }
            return y1.compareTo(y2);
        }).map(WebGridsterLayoutDashboard::getId).collect(Collectors.toList());
        Map<String, AgileDataIntermediateDataItem> mappedDataItem = this.data.stream().collect(Collectors.toMap(AgileDataIntermediateDataItem::getBizDataId, dataItem -> dataItem));
        ArrayList s = new ArrayList(this.data.size());
        dashboardLayoutBizIds.forEach(bizId -> {
            if (mappedDataItem.containsKey(bizId)) {
                s.add(mappedDataItem.get(bizId));
            }
        });
        this.sortedDataItems = CollectionUtils.isEmpty(s) ? this.data : s;
    }

    private void checkChartType() {
        for (AgileDataIntermediateDataItem datum : this.data) {
            if (!Objects.equals(AgileDataShowCategoryEnum.CHART.getValue(), datum.getShowCategory())) continue;
            ChartRenderSetting chartRenderSetting = datum.getChartRenderSetting();
            if (ChartTypeEnum.SCATTER.getType().equals(chartRenderSetting.getChartType()) || ChartTypeEnum.BUBBLE.getType().equals(chartRenderSetting.getChartType())) {
                return;
            }
            boolean isAllLine = chartRenderSetting.getValues().stream().allMatch(value -> Objects.equals(ChartTypeEnum.LINE.getType(), value.getChartType()));
            if (!isAllLine) continue;
            chartRenderSetting.setChartType(ChartTypeEnum.LINE.getType());
        }
    }

    public String getType() {
        return this.type;
    }

    public String getGenerateTime() {
        return this.generateTime;
    }

    public List<AgileDataIntermediateDataItem> getData() {
        return this.data;
    }

    public String getDataConclusion() {
        return this.dataConclusion;
    }

    public AgileDataRenderGraph getRenderGraph() {
        return this.renderGraph;
    }

    public List<WebDynamicLayout> getDynamicLayout() {
        return this.dynamicLayout;
    }

    public List<AgileDataIntermediateDataItem> getSortedDataItems() {
        return this.sortedDataItems;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setGenerateTime(String generateTime) {
        this.generateTime = generateTime;
    }

    public void setData(List<AgileDataIntermediateDataItem> data) {
        this.data = data;
    }

    public void setDataConclusion(String dataConclusion) {
        this.dataConclusion = dataConclusion;
    }

    public void setRenderGraph(AgileDataRenderGraph renderGraph) {
        this.renderGraph = renderGraph;
    }

    public void setDynamicLayout(List<WebDynamicLayout> dynamicLayout) {
        this.dynamicLayout = dynamicLayout;
    }

    @JsonIgnore
    public void setSortedDataItems(List<AgileDataIntermediateDataItem> sortedDataItems) {
        this.sortedDataItems = sortedDataItems;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AgileDataIntermediateLayout)) {
            return false;
        }
        AgileDataIntermediateLayout other = (AgileDataIntermediateLayout)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$generateTime = this.getGenerateTime();
        String other$generateTime = other.getGenerateTime();
        if (this$generateTime == null ? other$generateTime != null : !this$generateTime.equals(other$generateTime)) {
            return false;
        }
        List this$data = this.getData();
        List other$data = other.getData();
        if (this$data == null ? other$data != null : !((Object)this$data).equals(other$data)) {
            return false;
        }
        String this$dataConclusion = this.getDataConclusion();
        String other$dataConclusion = other.getDataConclusion();
        if (this$dataConclusion == null ? other$dataConclusion != null : !this$dataConclusion.equals(other$dataConclusion)) {
            return false;
        }
        AgileDataRenderGraph this$renderGraph = this.getRenderGraph();
        AgileDataRenderGraph other$renderGraph = other.getRenderGraph();
        if (this$renderGraph == null ? other$renderGraph != null : !this$renderGraph.equals(other$renderGraph)) {
            return false;
        }
        List this$dynamicLayout = this.getDynamicLayout();
        List other$dynamicLayout = other.getDynamicLayout();
        if (this$dynamicLayout == null ? other$dynamicLayout != null : !((Object)this$dynamicLayout).equals(other$dynamicLayout)) {
            return false;
        }
        List this$sortedDataItems = this.getSortedDataItems();
        List other$sortedDataItems = other.getSortedDataItems();
        return !(this$sortedDataItems == null ? other$sortedDataItems != null : !((Object)this$sortedDataItems).equals(other$sortedDataItems));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AgileDataIntermediateLayout;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $generateTime = this.getGenerateTime();
        result = result * 59 + ($generateTime == null ? 43 : $generateTime.hashCode());
        List $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        String $dataConclusion = this.getDataConclusion();
        result = result * 59 + ($dataConclusion == null ? 43 : $dataConclusion.hashCode());
        AgileDataRenderGraph $renderGraph = this.getRenderGraph();
        result = result * 59 + ($renderGraph == null ? 43 : $renderGraph.hashCode());
        List $dynamicLayout = this.getDynamicLayout();
        result = result * 59 + ($dynamicLayout == null ? 43 : ((Object)$dynamicLayout).hashCode());
        List $sortedDataItems = this.getSortedDataItems();
        result = result * 59 + ($sortedDataItems == null ? 43 : ((Object)$sortedDataItems).hashCode());
        return result;
    }

    public String toString() {
        return "AgileDataIntermediateLayout(type=" + this.getType() + ", generateTime=" + this.getGenerateTime() + ", data=" + this.getData() + ", dataConclusion=" + this.getDataConclusion() + ", renderGraph=" + this.getRenderGraph() + ", dynamicLayout=" + this.getDynamicLayout() + ", sortedDataItems=" + this.getSortedDataItems() + ")";
    }
}

