/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout;

import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponentWrapper;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponentWrapperJsonDeserializer;
import com.digiwin.mobile.mobileuibot.core.component.DataSource;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.LayoutComponentTypeEnum;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotPageLayout;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.util.CollectionUtils;

public class UiBotPageLayout
implements Serializable {
    private static final long serialVersionUID = -7678136368997085052L;
    private String pageBackgroudColor;
    private Boolean showMore;
    private String title;
    private Boolean titleVisible = false;
    private String pageId;
    private String schema;
    private String componentType;
    private String componentId;
    private Map<String, Object> lang;
    private DataSource dataSource;
    private String node;
    private String nodePath;
    @JsonDeserialize(contentUsing=BaseMobileComponentWrapperJsonDeserializer.class)
    private List<BaseMobileComponentWrapper<BaseMobileComponent>> header;
    @JsonDeserialize(contentUsing=BaseMobileComponentWrapperJsonDeserializer.class)
    private List<BaseMobileComponentWrapper<BaseMobileComponent>> body;
    @JsonDeserialize(contentUsing=BaseMobileComponentWrapperJsonDeserializer.class)
    private List<BaseMobileComponentWrapper<BaseMobileComponent>> bottom;
    List<Map<String, Object>> data;

    public void convert(String componentType) {
        if (CollectionUtils.isEmpty((Collection)this.data)) {
            return;
        }
        this.buildBody((Map)this.data.get(0), componentType);
        if (this.data.size() > 1) {
            this.buildBottom((Map)this.data.get(1));
        }
        this.data = null;
    }

    private void buildBody(Map<String, Object> body, String componentType) {
        if (CollectionUtils.isEmpty(body)) {
            return;
        }
        if (LayoutComponentTypeEnum.SINGLE_HEAD.getValue().equalsIgnoreCase(componentType)) {
            HashMap<String, ArrayList> map = new HashMap<String, ArrayList>(1);
            map.put("data", Lists.newArrayList((Object[])new Map[]{body}));
            Layout layout = (Layout)JsonUtil.objectToJavaObject(map, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            if (layout == null) {
                return;
            }
            this.body = layout.getData();
        } else {
            MobileCrudBlock mobileCrudBlock = (MobileCrudBlock)JsonUtil.objectToJavaObject(body, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            if (null == mobileCrudBlock) {
                return;
            }
            Layout layout = mobileCrudBlock.getData();
            if (null == layout) {
                return;
            }
            this.body = layout.getData();
        }
    }

    private void buildBottom(Map<String, Object> bottom) {
        if (CollectionUtils.isEmpty(bottom)) {
            return;
        }
        HashMap<String, ArrayList> map = new HashMap<String, ArrayList>(1);
        map.put("data", Lists.newArrayList((Object[])new Map[]{bottom}));
        Layout layout = (Layout)JsonUtil.objectToJavaObject(map, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        if (layout == null) {
            return;
        }
        this.bottom = layout.getData();
    }

    public List<BaseMobileComponentWrapper<BaseMobileComponent>> getHeader() {
        if (this.header == null) {
            this.header = new ArrayList();
        }
        return this.header;
    }

    public List<BaseMobileComponentWrapper<BaseMobileComponent>> getBody() {
        if (this.body == null) {
            this.body = new ArrayList();
        }
        return this.body;
    }

    public List<BaseMobileComponentWrapper<BaseMobileComponent>> getBottom() {
        if (this.bottom == null) {
            this.bottom = new ArrayList();
        }
        return this.bottom;
    }

    public String getPageBackgroudColor() {
        return this.pageBackgroudColor;
    }

    public Boolean getShowMore() {
        return this.showMore;
    }

    public String getTitle() {
        return this.title;
    }

    public Boolean getTitleVisible() {
        return this.titleVisible;
    }

    public String getPageId() {
        return this.pageId;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getComponentType() {
        return this.componentType;
    }

    public String getComponentId() {
        return this.componentId;
    }

    public Map<String, Object> getLang() {
        return this.lang;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public String getNode() {
        return this.node;
    }

    public String getNodePath() {
        return this.nodePath;
    }

    public List<Map<String, Object>> getData() {
        return this.data;
    }

    public void setPageBackgroudColor(String pageBackgroudColor) {
        this.pageBackgroudColor = pageBackgroudColor;
    }

    public void setShowMore(Boolean showMore) {
        this.showMore = showMore;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setTitleVisible(Boolean titleVisible) {
        this.titleVisible = titleVisible;
    }

    public void setPageId(String pageId) {
        this.pageId = pageId;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public void setComponentType(String componentType) {
        this.componentType = componentType;
    }

    public void setComponentId(String componentId) {
        this.componentId = componentId;
    }

    public void setLang(Map<String, Object> lang) {
        this.lang = lang;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setNode(String node) {
        this.node = node;
    }

    public void setNodePath(String nodePath) {
        this.nodePath = nodePath;
    }

    @JsonDeserialize(contentUsing=BaseMobileComponentWrapperJsonDeserializer.class)
    public void setHeader(List<BaseMobileComponentWrapper<BaseMobileComponent>> header) {
        this.header = header;
    }

    @JsonDeserialize(contentUsing=BaseMobileComponentWrapperJsonDeserializer.class)
    public void setBody(List<BaseMobileComponentWrapper<BaseMobileComponent>> body) {
        this.body = body;
    }

    @JsonDeserialize(contentUsing=BaseMobileComponentWrapperJsonDeserializer.class)
    public void setBottom(List<BaseMobileComponentWrapper<BaseMobileComponent>> bottom) {
        this.bottom = bottom;
    }

    public void setData(List<Map<String, Object>> data) {
        this.data = data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UiBotPageLayout)) {
            return false;
        }
        UiBotPageLayout other = (UiBotPageLayout)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$showMore = this.getShowMore();
        Boolean other$showMore = other.getShowMore();
        if (this$showMore == null ? other$showMore != null : !((Object)this$showMore).equals(other$showMore)) {
            return false;
        }
        Boolean this$titleVisible = this.getTitleVisible();
        Boolean other$titleVisible = other.getTitleVisible();
        if (this$titleVisible == null ? other$titleVisible != null : !((Object)this$titleVisible).equals(other$titleVisible)) {
            return false;
        }
        String this$pageBackgroudColor = this.getPageBackgroudColor();
        String other$pageBackgroudColor = other.getPageBackgroudColor();
        if (this$pageBackgroudColor == null ? other$pageBackgroudColor != null : !this$pageBackgroudColor.equals(other$pageBackgroudColor)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$pageId = this.getPageId();
        String other$pageId = other.getPageId();
        if (this$pageId == null ? other$pageId != null : !this$pageId.equals(other$pageId)) {
            return false;
        }
        String this$schema = this.getSchema();
        String other$schema = other.getSchema();
        if (this$schema == null ? other$schema != null : !this$schema.equals(other$schema)) {
            return false;
        }
        String this$componentType = this.getComponentType();
        String other$componentType = other.getComponentType();
        if (this$componentType == null ? other$componentType != null : !this$componentType.equals(other$componentType)) {
            return false;
        }
        String this$componentId = this.getComponentId();
        String other$componentId = other.getComponentId();
        if (this$componentId == null ? other$componentId != null : !this$componentId.equals(other$componentId)) {
            return false;
        }
        Map this$lang = this.getLang();
        Map other$lang = other.getLang();
        if (this$lang == null ? other$lang != null : !((Object)this$lang).equals(other$lang)) {
            return false;
        }
        DataSource this$dataSource = this.getDataSource();
        DataSource other$dataSource = other.getDataSource();
        if (this$dataSource == null ? other$dataSource != null : !this$dataSource.equals(other$dataSource)) {
            return false;
        }
        String this$node = this.getNode();
        String other$node = other.getNode();
        if (this$node == null ? other$node != null : !this$node.equals(other$node)) {
            return false;
        }
        String this$nodePath = this.getNodePath();
        String other$nodePath = other.getNodePath();
        if (this$nodePath == null ? other$nodePath != null : !this$nodePath.equals(other$nodePath)) {
            return false;
        }
        List this$header = this.getHeader();
        List other$header = other.getHeader();
        if (this$header == null ? other$header != null : !((Object)this$header).equals(other$header)) {
            return false;
        }
        List this$body = this.getBody();
        List other$body = other.getBody();
        if (this$body == null ? other$body != null : !((Object)this$body).equals(other$body)) {
            return false;
        }
        List this$bottom = this.getBottom();
        List other$bottom = other.getBottom();
        if (this$bottom == null ? other$bottom != null : !((Object)this$bottom).equals(other$bottom)) {
            return false;
        }
        List this$data = this.getData();
        List other$data = other.getData();
        return !(this$data == null ? other$data != null : !((Object)this$data).equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UiBotPageLayout;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $showMore = this.getShowMore();
        result = result * 59 + ($showMore == null ? 43 : ((Object)$showMore).hashCode());
        Boolean $titleVisible = this.getTitleVisible();
        result = result * 59 + ($titleVisible == null ? 43 : ((Object)$titleVisible).hashCode());
        String $pageBackgroudColor = this.getPageBackgroudColor();
        result = result * 59 + ($pageBackgroudColor == null ? 43 : $pageBackgroudColor.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $pageId = this.getPageId();
        result = result * 59 + ($pageId == null ? 43 : $pageId.hashCode());
        String $schema = this.getSchema();
        result = result * 59 + ($schema == null ? 43 : $schema.hashCode());
        String $componentType = this.getComponentType();
        result = result * 59 + ($componentType == null ? 43 : $componentType.hashCode());
        String $componentId = this.getComponentId();
        result = result * 59 + ($componentId == null ? 43 : $componentId.hashCode());
        Map $lang = this.getLang();
        result = result * 59 + ($lang == null ? 43 : ((Object)$lang).hashCode());
        DataSource $dataSource = this.getDataSource();
        result = result * 59 + ($dataSource == null ? 43 : $dataSource.hashCode());
        String $node = this.getNode();
        result = result * 59 + ($node == null ? 43 : $node.hashCode());
        String $nodePath = this.getNodePath();
        result = result * 59 + ($nodePath == null ? 43 : $nodePath.hashCode());
        List $header = this.getHeader();
        result = result * 59 + ($header == null ? 43 : ((Object)$header).hashCode());
        List $body = this.getBody();
        result = result * 59 + ($body == null ? 43 : ((Object)$body).hashCode());
        List $bottom = this.getBottom();
        result = result * 59 + ($bottom == null ? 43 : ((Object)$bottom).hashCode());
        List $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        return result;
    }

    public String toString() {
        return "UiBotPageLayout(pageBackgroudColor=" + this.getPageBackgroudColor() + ", showMore=" + this.getShowMore() + ", title=" + this.getTitle() + ", titleVisible=" + this.getTitleVisible() + ", pageId=" + this.getPageId() + ", schema=" + this.getSchema() + ", componentType=" + this.getComponentType() + ", componentId=" + this.getComponentId() + ", lang=" + this.getLang() + ", dataSource=" + this.getDataSource() + ", node=" + this.getNode() + ", nodePath=" + this.getNodePath() + ", header=" + this.getHeader() + ", body=" + this.getBody() + ", bottom=" + this.getBottom() + ", data=" + this.getData() + ")";
    }
}

