/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.parser;

import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcTaskWithBacklogData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotDataSourceDTO;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotPageDefine;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotSubmitAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotSubmitExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotSubmitType;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmActivity;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmDataState;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmPage;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.parser.AbstractCombineSubmitActionParser;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.PcUiBotPatternUtil;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.PcUiBotSubmitActionUtil;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
@Scope(value="prototype")
public class TaskCombineSubmitActionParser
extends AbstractCombineSubmitActionParser {
    private static final String PRE_APPROVE_ACTION_TYPE = "TaskEngine";
    private static final String PRE_APPROVE_ACTION_SERVICE = "reapprove";
    private PcUiBotExecuteContext executeContext;
    private PcUiBotTmActivity tmActivity;

    public void init(PcUiBotExecuteContext executeContext, PcUiBotTmActivity tmActivity, PcUiBotTmDataState tmDataState, PcUiBotPageDefine pageDefine) {
        super.init(tmDataState, pageDefine);
        this.executeContext = executeContext;
        this.tmActivity = tmActivity;
    }

    protected PcUiBotSubmitAction buildSubmitAction(PcUiBotTmAction tmAction) {
        if (!this.showPreApproveAction(tmAction, this.executeContext)) {
            return null;
        }
        PcUiBotTmPage tmPage = this.tmActivity.getPages();
        PcUiBotSubmitAction submitAction = this.newTaskSubmitActionCreateService.create(this.executeContext, this.executeContext.getProjectData(), this.executeContext.getTaskWithBacklogData(), tmAction, this.tmActivity);
        this.tmApprovalService.setApprovalActionStartApproveActivity(submitAction, this.tmActivity);
        if (tmAction.getIsCustomize() != null && tmAction.getIsCustomize().booleanValue()) {
            submitAction.setExecuteContext(PcUiBotSubmitExecuteContext.create((PcUiBotExecuteContext)this.executeContext, (DigiwinAtmcTaskWithBacklogData)this.executeContext.getTaskWithBacklogData()));
            submitAction.setIsCustomize(Boolean.valueOf(true));
            submitAction.setUuid(tmAction.getUuid());
            submitAction.setBtnId(tmAction.getBtnId());
            submitAction.setBtnType(tmAction.getBtnType());
            submitAction.setJumpAction(tmAction.getJumpAction());
            submitAction.setTitle(tmAction.getTitle());
            submitAction.setType(tmAction.getType());
            submitAction.setActionParams(tmAction.getActionParams());
            if (tmAction.getSchema() != null) {
                submitAction.setSchema(tmAction.getSchema());
            }
        }
        if (submitAction.getSubmitType() == null) {
            if (this.tmDataState.getSubmitType() != null) {
                submitAction.setSubmitType(this.tmDataState.getSubmitType());
            } else {
                PcUiBotSubmitType submitType = new PcUiBotSubmitType();
                submitType.setIsBatch(Boolean.valueOf(false));
                submitType.setSchema(this.pageDefine.getDataSourceSet().getMainDatasource());
                submitAction.setSubmitType(submitType);
                this.tmDataState.setSubmitType(submitType);
            }
        }
        if (submitAction.isTaskEngin() || PcUiBotSubmitActionUtil.isTaskWithdrawAction((PcUiBotSubmitAction)submitAction)) {
            if (tmAction.getCheckCompleteAction() != null) {
                PcUiBotDataSourceDTO dataSourceBase = this.tmDataSourceService.analysis(this.executeContext, "", tmAction.getCheckCompleteAction(), ((DigiwinAtmcTaskWithBacklogData)this.executeContext.getTaskWithBacklogDataList().get(0)).getBpmData());
                submitAction.setCheckCompleteAction(dataSourceBase);
            } else if (this.tmDataState.getSubmitType() != null && BooleanUtils.isTrue((Boolean)this.tmDataState.getSubmitType().getIsBatch()) && !Objects.equals(this.tmDataState.getSubmitType().getByActivity(), true) && !this.pageDefine.getDataSourceSet().isEmpty() && !Objects.equals(tmAction.getType(), "TM")) {
                submitAction.setCheckCompleteAction(this.pageDefine.getDataSourceSet().getFirstDataQuery().copyWithoutProcessor());
            }
        }
        if (tmPage.getEnableDataState() != null && tmPage.getEnableDataState().booleanValue()) {
            submitAction.setTargetDataState(tmAction.getTargetDataState());
        }
        if (!CollectionUtils.isEmpty((Map)tmAction.getParas())) {
            if (!CollectionUtils.isEmpty((Map)submitAction.getParas())) {
                submitAction.getParas().putAll(tmAction.getParas());
            } else {
                submitAction.setParas(tmAction.getParas());
            }
        }
        return submitAction;
    }

    private boolean showPreApproveAction(PcUiBotTmAction tmAction, PcUiBotExecuteContext executeContext) {
        boolean isModelDriven = PcUiBotPatternUtil.isModelDriven((PcUiBotExecuteContext)executeContext);
        if (isModelDriven) {
            return true;
        }
        if (this.isPreApproveAction(tmAction)) {
            if (executeContext.getHasApprove() == null) {
                return false;
            }
            return executeContext.getHasApprove();
        }
        return true;
    }

    private boolean isPreApproveAction(PcUiBotTmAction tmAction) {
        if (tmAction == null) {
            return false;
        }
        if (StringUtils.equals((CharSequence)PRE_APPROVE_ACTION_TYPE, (CharSequence)tmAction.getType()) && StringUtils.equals((CharSequence)PRE_APPROVE_ACTION_SERVICE, (CharSequence)tmAction.getServiceName())) {
            return true;
        }
        if (!CollectionUtils.isEmpty((Collection)tmAction.getAttachActions())) {
            for (PcUiBotTmAction attachAction : tmAction.getAttachActions()) {
                if (!this.isPreApproveAction(attachAction)) continue;
                return true;
            }
        }
        return false;
    }
}

