/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service;

import com.digiwin.mobile.mobileuibot.common.http.model.AthenaBasicHttpRequestHead;
import com.digiwin.mobile.mobileuibot.proxy.DigiwinAthenaApiRequest;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.model.response.metadata.KnowledgeMapsActionMetadataQueryResult;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.service.DigiwinKnowledgeMapsProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotActionParameterMapping;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotApiMetadata;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotMetadataField;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotSubmitAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service.MetadataService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.PcUiBotApiMetadataUtil;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.PcUiBotDefaultTagUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class AnalyseSubmitActionFieldService {
    @Autowired
    protected DigiwinKnowledgeMapsProxyService digiwinKnowledgeMapsProxyService;
    @Autowired
    MetadataService metadataService;

    public void submitMetadataFiledToGetMetadata(PcUiBotExecuteContext executeContext, PcUiBotApiMetadata masterMetadata, List<PcUiBotSubmitAction> submitActions) {
        if (CollectionUtils.isEmpty(submitActions)) {
            return;
        }
        for (PcUiBotSubmitAction submitAction : submitActions) {
            if (!CollectionUtils.isEmpty((Collection)submitAction.getCombineActions())) {
                this.submitMetadataFiledToGetMetadata(executeContext, masterMetadata, submitAction.getCombineActions());
            }
            if (CollectionUtils.isEmpty((Collection)submitAction.getActionParams())) continue;
            List appendActionParams = this.findAppendActionParam(submitAction.getActionParams(), masterMetadata.getResponseFields());
            this.appendActionParamBySubmitMetadata(appendActionParams, executeContext, (PcUiBotAction)submitAction, masterMetadata);
        }
    }

    private List<PcUiBotActionParameterMapping> findAppendActionParam(List<PcUiBotActionParameterMapping> actionParams, List<PcUiBotMetadataField> masterMetadataResponseFields) {
        ArrayList<PcUiBotActionParameterMapping> appendActionParams = new ArrayList<PcUiBotActionParameterMapping>();
        for (PcUiBotActionParameterMapping actionParam : actionParams) {
            if (!this.matchActionParamAndMasterMetadata("", masterMetadataResponseFields, actionParam)) continue;
            appendActionParams.add(actionParam);
        }
        return appendActionParams;
    }

    private boolean matchActionParamAndMasterMetadata(String parentPathName, List<PcUiBotMetadataField> masterMetadataResponseFields, PcUiBotActionParameterMapping actionParam) {
        boolean status = true;
        if (masterMetadataResponseFields != null) {
            for (PcUiBotMetadataField metadataField : masterMetadataResponseFields) {
                String pathFieldName = PcUiBotApiMetadataUtil.pathFieldName((String)parentPathName, (PcUiBotMetadataField)metadataField);
                if ("object".equals(metadataField.getDataType())) {
                    status = this.matchActionParamAndMasterMetadata(pathFieldName, metadataField.getSubFields(), actionParam);
                }
                if (!"GET_ACTION_RESPONSE".equals(actionParam.getType()) || !pathFieldName.equals(actionParam.getValue())) continue;
                return false;
            }
        }
        return status;
    }

    private void appendActionParamBySubmitMetadata(List<PcUiBotActionParameterMapping> appendActionParams, PcUiBotExecuteContext executeContext, PcUiBotAction submitAction, PcUiBotApiMetadata masterMetadata) {
        if (CollectionUtils.isEmpty(appendActionParams)) {
            return;
        }
        PcUiBotApiMetadata submitMetadata = null;
        if ("ESP".equals(submitAction.getCategory())) {
            submitMetadata = this.getMetadata(executeContext, submitAction.getActionId());
        }
        if (submitMetadata == null) {
            return;
        }
        for (PcUiBotActionParameterMapping actionParam : appendActionParams) {
            List masterMetadataFields;
            PcUiBotMetadataField submitMetadataField;
            if (!"GET_ACTION_RESPONSE".equals(actionParam.getType()) || !"ACTIVE_ROW".equals(actionParam.getType()) || (submitMetadataField = this.findActionParamFiledBySubmitMetadata("", submitMetadata.getRequestFields(), actionParam.getValue())) == null || CollectionUtils.isEmpty((Collection)(masterMetadataFields = this.appendSubmitMetadataFiledToGetMetadata("", masterMetadata.getResponseFields(), StringUtils.substringBeforeLast((String)actionParam.getValue(), (String)".")))) || !this.respFieldsNotContains(submitMetadataField, masterMetadataFields)) continue;
            submitMetadataField.setTagDefinitions(PcUiBotDefaultTagUtils.createDataTypeTagDefinitions((PcUiBotMetadataField)submitMetadataField));
            masterMetadataFields.add(submitMetadataField);
        }
    }

    private PcUiBotApiMetadata getMetadata(PcUiBotExecuteContext executeContext, String actionId) {
        DigiwinAthenaApiRequest athenaApiRequest = DigiwinAthenaApiRequest.builder().requestHead(new AthenaBasicHttpRequestHead("", executeContext.getLocale(), executeContext.getAuthoredUser().getToken(), executeContext.getTenantId())).uriVariables("actionId", actionId).build();
        KnowledgeMapsActionMetadataQueryResult rawMetadataQueryResult = this.digiwinKnowledgeMapsProxyService.actionMetadata(athenaApiRequest);
        return this.metadataService.createApiMetadata(rawMetadataQueryResult);
    }

    private boolean respFieldsNotContains(PcUiBotMetadataField submitMetadataField, List<PcUiBotMetadataField> masterMetadataFields) {
        Optional<PcUiBotMetadataField> optional = masterMetadataFields.stream().filter(masterMetadataField -> StringUtils.equals((CharSequence)submitMetadataField.getName(), (CharSequence)masterMetadataField.getName()) && StringUtils.equals((CharSequence)submitMetadataField.getDataType(), (CharSequence)masterMetadataField.getDataType())).findFirst();
        return !optional.isPresent();
    }

    private PcUiBotMetadataField findActionParamFiledBySubmitMetadata(String subFieldName, List<PcUiBotMetadataField> metadataFields, String filedName) {
        for (PcUiBotMetadataField metadataField : metadataFields) {
            PcUiBotMetadataField returnMetadataField;
            String pathFieldName = PcUiBotApiMetadataUtil.pathFieldName((String)subFieldName, (PcUiBotMetadataField)metadataField);
            if (pathFieldName.equals(filedName)) {
                return metadataField;
            }
            if (!"object".equals(metadataField.getDataType()) || (returnMetadataField = this.findActionParamFiledBySubmitMetadata(metadataField.getName(), metadataField.getSubFields(), filedName)) == null) continue;
            return returnMetadataField;
        }
        return null;
    }

    private List<PcUiBotMetadataField> appendSubmitMetadataFiledToGetMetadata(String subFieldName, List<PcUiBotMetadataField> metadataFields, String filedName) {
        for (PcUiBotMetadataField metadataField : metadataFields) {
            List returnMetadataField;
            String pathFieldName = PcUiBotApiMetadataUtil.pathFieldName((String)subFieldName, (PcUiBotMetadataField)metadataField);
            if (pathFieldName.equals(filedName)) {
                return metadataField.getSubFields();
            }
            if (!"object".equals(metadataField.getDataType()) || CollectionUtils.isEmpty((Collection)(returnMetadataField = this.appendSubmitMetadataFiledToGetMetadata(metadataField.getName(), metadataField.getSubFields(), filedName)))) continue;
            return returnMetadataField;
        }
        return Collections.emptyList();
    }
}

