/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service;

import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotDataSourceDTO;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotQueryAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmDataProcess;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmQueryAction;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public final class DataSourceDTOFactory {
    public static PcUiBotDataSourceDTO createDataSource(List<PcUiBotQueryAction> actionList, List<PcUiBotTmDataProcess> dataSourceProcessors, String key, PcUiBotTmQueryAction tmAction) {
        if (actionList.size() > 1) {
            PcUiBotDataSourceDTO unionDataSource = new PcUiBotDataSourceDTO();
            ArrayList<PcUiBotDataSourceDTO> unionItems = new ArrayList<PcUiBotDataSourceDTO>();
            int count = 1;
            for (PcUiBotQueryAction action : actionList) {
                PcUiBotDataSourceDTO dataSourceBase = DataSourceDTOFactory.create((PcUiBotTmQueryAction)tmAction, (PcUiBotQueryAction)action, (String)(key + count), dataSourceProcessors, (boolean)false);
                if (dataSourceBase != null) {
                    unionItems.add(dataSourceBase);
                }
                ++count;
            }
            unionDataSource.setActionId(actionList.get(0).getActionId());
            unionDataSource.setName(key);
            unionDataSource.setUnionItems(unionItems);
            unionDataSource.setDataKeys(tmAction.getDataKeys());
            unionDataSource.setMetadataFields(tmAction.getMetadataFields());
            unionDataSource.setType("MIX_UNION");
            return unionDataSource;
        }
        if (CollectionUtils.isEmpty(actionList)) {
            return null;
        }
        PcUiBotQueryAction action = actionList.get(0);
        PcUiBotDataSourceDTO dataSource = DataSourceDTOFactory.create((PcUiBotTmQueryAction)tmAction, (PcUiBotQueryAction)action, (String)key, dataSourceProcessors, (boolean)false);
        return dataSource;
    }

    public static PcUiBotDataSourceDTO create(PcUiBotTmQueryAction tmAction, PcUiBotQueryAction action, String key, List<PcUiBotTmDataProcess> dataSourceProcessors, boolean isRoot) {
        if (StringUtils.isEmpty((Object)key) && tmAction != null) {
            key = tmAction.getName();
        }
        PcUiBotDataSourceDTO dataSource = null;
        switch (action.getCategory()) {
            case "ESP": {
                PcUiBotDataSourceDTO espDataSource = new PcUiBotDataSourceDTO();
                espDataSource.setType("ESP");
                dataSource = espDataSource;
                break;
            }
            case "TM": {
                ArrayList dataKeys = Lists.newArrayList((Object[])new String[]{"sm_iqc.get.old", "sm_iqc.get.new", "athena_MechanismRecordGet", "athena_TimeIntervalCodeGet"});
                if (!dataKeys.contains(action.getActionId())) break;
                PcUiBotDataSourceDTO tmDataSource = new PcUiBotDataSourceDTO();
                tmDataSource.setType("TM");
                dataSource = tmDataSource;
                break;
            }
            case "RAWDATA": {
                PcUiBotDataSourceDTO rawDataSource = new PcUiBotDataSourceDTO();
                rawDataSource.setType("RAWDATA");
                rawDataSource.setName(key);
                if (!CollectionUtils.isEmpty((Map)action.getParas())) {
                    HashMap value = (HashMap)action.getParas();
                    rawDataSource.setRawData(value);
                }
                dataSource = rawDataSource;
                break;
            }
            case "SD": {
                PcUiBotDataSourceDTO sdDataSource = new PcUiBotDataSourceDTO();
                sdDataSource.setType("SD");
                dataSource = sdDataSource;
                break;
            }
            case "ATMC_CHANGE": {
                PcUiBotDataSourceDTO changeTaskDataSource = new PcUiBotDataSourceDTO();
                changeTaskDataSource.setType("ATMC_CHANGE");
                dataSource = changeTaskDataSource;
                break;
            }
            case "ATMC": {
                PcUiBotDataSourceDTO changeTaskDataSource = new PcUiBotDataSourceDTO();
                changeTaskDataSource.setType("ATMC");
                dataSource = changeTaskDataSource;
                break;
            }
            case "LCDP": {
                PcUiBotDataSourceDTO changeTaskDataSource = new PcUiBotDataSourceDTO();
                changeTaskDataSource.setType("LCDP");
                dataSource = changeTaskDataSource;
                break;
            }
            case "PTM_DATA": {
                PcUiBotDataSourceDTO ptmDataSource = new PcUiBotDataSourceDTO();
                ptmDataSource.setType("PTM_DATA");
                dataSource = ptmDataSource;
                break;
            }
        }
        if (dataSource != null) {
            dataSource.setAction(action);
            dataSource.setActionId(tmAction.getActionId());
            dataSource.setName(key);
            dataSource.setDataSourceProcessors(dataSourceProcessors);
            dataSource.setDataKeys(tmAction.getDataKeys());
            dataSource.setLimit(tmAction.getLimit());
            dataSource.setNotArray(tmAction.getNotArray());
            dataSource.setOverride(tmAction.getOverride());
            if (isRoot) {
                dataSource.setMetadataFields(tmAction.getMetadataFields());
            }
        }
        return dataSource;
    }
}

