/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotMetadataField;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotPageDefine;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotRuleDTO;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmWordCapability;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotWordQuery;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.QueryResult;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.QueryResultSet;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.rule.UiBotRule;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.tag.PcUiBotTagDefinition;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service.TagDisplayRangeService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service.TagMergeService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.PcUiBotScriptUtil;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ShowFieldService {
    @Autowired
    protected TagDisplayRangeService tagDisplayRangeService;
    @Autowired
    TagMergeService tagMergeService;
    protected static final Map<String, String> TAG_CATEGORY_LIST = new HashMap();

    public void addShowFieldByFullName(String fullName, PcUiBotMetadataField rootField, Map<String, PcUiBotMetadataField> needShowFields) {
        block16: {
            block15: {
                if (fullName.contains(".")) break block15;
                String newFullName = rootField.getName() + "." + fullName;
                if (rootField.getFieldMap() == null || !rootField.getFieldMap().containsKey(fullName) || needShowFields.containsKey(newFullName)) break block16;
                boolean isShow = false;
                if (((PcUiBotMetadataField)rootField.getFieldMap().get(fullName)).getTagDefinitions() != null) {
                    isShow = true;
                    for (PcUiBotTagDefinition tag : ((PcUiBotMetadataField)rootField.getFieldMap().get(fullName)).getTagDefinitions()) {
                        if (!TAG_CATEGORY_LIST.containsKey(tag.getCategory())) continue;
                        isShow = false;
                        break;
                    }
                }
                if (((PcUiBotMetadataField)rootField.getFieldMap().get(fullName)).getDataType().equals("object")) {
                    PcUiBotTagDefinition tagDefinitionDTO = this.tagMergeService.mergeTagAttributes((PcUiBotMetadataField)rootField.getFieldMap().get(fullName));
                    isShow = tagDefinitionDTO == null || !"customizeComponentInterpreter".equals(tagDefinitionDTO.getInterpreterServiceName());
                }
                if (!isShow) break block16;
                needShowFields.put(newFullName, (PcUiBotMetadataField)rootField.getFieldMap().get(fullName));
                break block16;
            }
            String[] paths = fullName.split("\\.");
            PcUiBotMetadataField existedField = rootField.findByPath(paths);
            if (existedField != null) {
                boolean isShow = true;
                if (existedField.getTagDefinitions() != null) {
                    for (PcUiBotTagDefinition tag : existedField.getTagDefinitions()) {
                        if (!TAG_CATEGORY_LIST.containsKey(tag.getCategory())) continue;
                        isShow = false;
                        break;
                    }
                } else {
                    PcUiBotTagDefinition tagDefinitionDTO;
                    isShow = existedField.getDataType().equals("object") ? (tagDefinitionDTO = this.tagMergeService.mergeTagAttributes(existedField)) == null || !"customizeComponentInterpreter".equals(tagDefinitionDTO.getInterpreterServiceName()) : false;
                }
                if (paths.length == 2) {
                    if (!needShowFields.containsKey(existedField.getFullName()) && existedField.getTagDefinitions() != null && isShow) {
                        needShowFields.put(existedField.getFullName(), existedField);
                    }
                } else {
                    ArrayList<PcUiBotMetadataField> fieldList = new ArrayList<PcUiBotMetadataField>();
                    fieldList.add(existedField);
                    for (PcUiBotMetadataField parentField = existedField.getParentField(); parentField != null && !parentField.equals((Object)rootField); parentField = parentField.getParentField()) {
                        fieldList.add(parentField);
                    }
                    PcUiBotMetadataField metadataField = (PcUiBotMetadataField)fieldList.get(fieldList.size() - 1);
                    if (!needShowFields.containsKey(metadataField.getFullName()) && metadataField.getTagDefinitions() != null && isShow) {
                        needShowFields.put(metadataField.getFullName(), metadataField.clone(null, new ArrayList()));
                    }
                    PcUiBotMetadataField parent = needShowFields.get(metadataField.getFullName());
                    for (int i = fieldList.size() - 2; i >= 0; --i) {
                        PcUiBotMetadataField subField = parent.getField(((PcUiBotMetadataField)fieldList.get(i)).getName());
                        if (subField == null) {
                            subField = ((PcUiBotMetadataField)fieldList.get(i)).clone(parent, (List)(i == 0 ? null : new ArrayList()));
                            parent.addField(subField);
                        }
                        parent = subField;
                    }
                }
            }
        }
    }

    public List<PcUiBotMetadataField> refreshObjectField(PcUiBotExecuteContext executeContext, Map<String, PcUiBotMetadataField> needShowFields, PcUiBotMetadataField rootField, QueryResultSet queryResultSet, PcUiBotPageDefine pageDefine) {
        LinkedHashMap<String, PcUiBotMetadataField> needShowFields_obj = new LinkedHashMap<String, PcUiBotMetadataField>();
        ArrayList<PcUiBotMetadataField> tagMetadata = new ArrayList<PcUiBotMetadataField>();
        tagMetadata.addAll(needShowFields.values());
        for (PcUiBotMetadataField subField : rootField.getSubFields()) {
            if (!"object".equals(subField.getDataType()) || needShowFields.containsKey(rootField.getName() + "." + subField.getName())) continue;
            needShowFields_obj.put(rootField.getName() + "." + subField.getName(), subField);
            List tagMetadata_obj = this.tagDisplayRangeService.getShowTagFields(executeContext, subField, queryResultSet, pageDefine);
            if (CollectionUtils.isEmpty((Collection)tagMetadata_obj)) continue;
            tagMetadata.addAll(tagMetadata_obj);
        }
        return tagMetadata;
    }

    private QueryResult getMainQueryResult(QueryResultSet queryResultSet) {
        if (null == queryResultSet || null == queryResultSet.getMainQueryResult() || CollectionUtils.isEmpty((Collection)queryResultSet.getMainQueryResult().getData())) {
            return null;
        }
        return queryResultSet.getMainQueryResult();
    }

    public List<String> getWordsByAbility(PcUiBotExecuteContext executeContext, List<Object> apiMetadata, QueryResultSet queryResultSet, PcUiBotPageDefine pageDefine) {
        ArrayList enabledAcCodes = new ArrayList();
        ArrayList disabledAcCodes = new ArrayList();
        QueryResult mainQueryResult = this.getMainQueryResult(queryResultSet);
        this.parseWordCapabilityAcCodes(enabledAcCodes, disabledAcCodes, mainQueryResult, pageDefine);
        PcUiBotWordQuery wordQuery = new PcUiBotWordQuery();
        wordQuery.setEnabledAcCodes(enabledAcCodes);
        wordQuery.setDisabledAcCodes(disabledAcCodes);
        HashMap wordAbilityStateMap = new HashMap();
        List fieldNameList = wordQuery.getFields();
        ArrayList enableFieldNameList = new ArrayList();
        Map wordHiddenMap = this.parseWordHiddenRule(executeContext, pageDefine.getRules(), enableFieldNameList, mainQueryResult);
        List hiddenWords = this.mergeHiddenWords(wordAbilityStateMap, wordHiddenMap);
        this.setHiddenEffective(pageDefine.getRules(), hiddenWords);
        return hiddenWords;
    }

    private void setHiddenEffective(List<Map<String, Object>> rules, List<String> hiddenWords) {
        for (Map<String, Object> rule : rules) {
            String schema = String.valueOf(rule.get("schema"));
            String key = String.valueOf(rule.get("key"));
            if (!"hidden".equals(key) || !hiddenWords.contains(schema)) continue;
            rule.put("effective", Boolean.TRUE);
        }
    }

    public void removeWordHiddenRule(List<UiBotRule> ruleList) {
        ruleList = Optional.ofNullable(ruleList).orElse(Lists.newArrayList());
        HashSet hiddenWordAllSet = Sets.newHashSet();
        HashSet hiddenWordOnlySet = Sets.newHashSet();
        ruleList.forEach(ruleMap -> {
            String ruleKey = ruleMap.getKey();
            String schema = ruleMap.getSchema();
            String targetSchema = ruleMap.getTargetSchema();
            Object[] linkageSchemas = ruleMap.getLinkageSchemas();
            Boolean effective = ruleMap.getEffective();
            boolean isHidden = "hidden".equals(ruleKey);
            if (isHidden) {
                if (BooleanUtils.isTrue((Boolean)effective)) {
                    hiddenWordAllSet.add(schema);
                    hiddenWordAllSet.add(targetSchema);
                    CollUtil.addAll((Collection)hiddenWordAllSet, (Object[])linkageSchemas);
                } else {
                    hiddenWordOnlySet.add(schema);
                }
            }
        });
        CollUtil.removeNull((Collection)hiddenWordAllSet);
        ruleList.removeIf(ruleMap -> {
            String ruleKey = ruleMap.getKey();
            String schema = ruleMap.getSchema();
            return hiddenWordAllSet.contains(schema) || "hidden".equals(ruleKey) && hiddenWordOnlySet.contains(schema);
        });
    }

    private Map<String, Boolean> parseWordHiddenRule(PcUiBotExecuteContext executeContext, List<Map<String, Object>> ruleList, List<String> enableFieldNameList, QueryResult mainQueryResult) {
        List availableWordHiddenRules = this.getAvailableWordHiddenRule(ruleList);
        return this.getWordHiddenMap(executeContext, availableWordHiddenRules, enableFieldNameList, mainQueryResult);
    }

    private Map<String, Boolean> getWordHiddenMap(PcUiBotExecuteContext executeContext, List<PcUiBotRuleDTO.Rule> wordHiddenRuleList, List<String> enableFieldNameList, QueryResult mainQueryResult) {
        HashMap<String, Boolean> wordHiddenMap = new HashMap<String, Boolean>();
        if (CollectionUtils.isEmpty(wordHiddenRuleList)) {
            return wordHiddenMap;
        }
        String tenantId = executeContext.getTenantId();
        ArrayList productNameList = new ArrayList();
        Map conditionParams = this.buildConditionParams(tenantId, productNameList, mainQueryResult);
        for (PcUiBotRuleDTO.Rule rule : wordHiddenRuleList) {
            String schema = rule.getSchema();
            String condition = rule.getTrigger().getCondition();
            condition = this.dealForHeadlessAbility(schema, condition, enableFieldNameList);
            boolean conditionResult = this.conditionHandle(condition, conditionParams);
            wordHiddenMap.put(schema, conditionResult);
            List linkageSchemas = rule.getLinkageSchemas();
            linkageSchemas = Optional.ofNullable(linkageSchemas).orElse(Lists.newArrayList());
            for (String linkageSchema : linkageSchemas) {
                wordHiddenMap.put(linkageSchema, conditionResult);
            }
        }
        return wordHiddenMap;
    }

    private Map<String, Object> buildConditionParams(String tenantId, List<String> productNameList, QueryResult mainQueryResult) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("T", tenantId);
        params.put("P_A", "[" + String.join((CharSequence)",", productNameList) + "]");
        if (!CollectionUtils.isEmpty(productNameList)) {
            params.put("P", productNameList.get(0));
            params.put("P_E", productNameList.get(productNameList.size() - 1));
        }
        if (mainQueryResult != null) {
            params.put(mainQueryResult.getDataSourceName(), mainQueryResult.getData());
        }
        return params;
    }

    private String dealForHeadlessAbility(String fieldName, String condition, List<String> enableFieldNameList) {
        if ("HEADLESS_ABILITY".contains(condition)) {
            String headlessCondition = Boolean.FALSE.toString();
            if (enableFieldNameList != null && !enableFieldNameList.contains(fieldName)) {
                headlessCondition = Boolean.TRUE.toString();
            }
            return StrUtil.replace((CharSequence)condition, (CharSequence)"HEADLESS_ABILITY", (CharSequence)headlessCondition);
        }
        return condition;
    }

    private List<PcUiBotRuleDTO.Rule> getAvailableWordHiddenRule(List<Map<String, Object>> rules) {
        List ruleList = (List)JsonUtil.objectToJavaObject(rules, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        return ruleList.stream().filter(ele -> Objects.nonNull(ele.getTrigger())).filter(ele -> "hidden".equals(ele.getKey())).filter(ele -> "default".equals(ele.getTrigger().getPoint())).filter(ele -> StringUtils.isNotEmpty((CharSequence)ele.getTrigger().getCondition())).collect(Collectors.toList());
    }

    private Set<String> getHiddenWords(Map<String, Boolean> wordHiddenMap) {
        HashSet hiddenWords = Sets.newHashSet();
        wordHiddenMap.forEach((k, v) -> {
            if (BooleanUtils.isTrue((Boolean)v)) {
                hiddenWords.add(k);
            }
        });
        return hiddenWords;
    }

    private List<String> mergeHiddenWords(Map<String, Set<String>> wordAbilityStateMap, Map<String, Boolean> wordHiddenMap) {
        Set<String> excludeWords = wordAbilityStateMap.get("excludes");
        Set hiddenWords = this.getHiddenWords(wordHiddenMap);
        return Lists.newArrayList((Iterable)CollUtil.unionDistinct(excludeWords, (Collection)hiddenWords, (Collection[])new Collection[0]));
    }

    private boolean conditionHandle(String condition, Map<String, Object> params) {
        Boolean[] result = new Boolean[]{false};
        PcUiBotScriptUtil.evalJs((String)condition, params, (engine, executeResult) -> {
            if (executeResult instanceof Boolean) {
                result[0] = (Boolean)executeResult;
            }
        });
        return result[0] != null && result[0] != false;
    }

    private void parseWordCapabilityAcCodes(List<String> enabledAcCodes, List<String> disabledAcCodes, QueryResult mainQueryResult, PcUiBotPageDefine pageDefine) {
        if (mainQueryResult == null) {
            return;
        }
        this.parseWordCapabilityAcCodes(enabledAcCodes, disabledAcCodes, mainQueryResult.getDataSourceName(), mainQueryResult.getData(), pageDefine.getWordCapability());
    }

    protected void parseWordCapabilityAcCodes(List<String> enabledAcCodes, List<String> disabledAcCodes, String dataSourceName, List<Map<String, Object>> pageDataList, List<PcUiBotTmWordCapability> wordCapabilities) {
        if (CollectionUtils.isEmpty(wordCapabilities) || CollectionUtils.isEmpty(pageDataList)) {
            return;
        }
        for (PcUiBotTmWordCapability wordCapability : wordCapabilities) {
            this.parseWordCapabilityAcCodes(enabledAcCodes, disabledAcCodes, dataSourceName, pageDataList, wordCapability);
        }
    }

    protected void parseWordCapabilityAcCodes(List<String> enabledAcCodes, List<String> disabledAcCodes, String dataSourceName, List<Map<String, Object>> pageDataList, PcUiBotTmWordCapability wordCapability) {
        if (StringUtils.isBlank((CharSequence)wordCapability.getCondition()) || CollectionUtils.isEmpty((Collection)wordCapability.getEnabledAcCodes()) && CollectionUtils.isEmpty((Collection)wordCapability.getDisabledAcCodes())) {
            return;
        }
        HashMap<String, List<Map<String, Object>>> params = new HashMap<String, List<Map<String, Object>>>();
        params.put(dataSourceName, pageDataList);
        PcUiBotScriptUtil.evalJs((String)wordCapability.getCondition(), params, (engine, executeResult) -> {
            if (null != executeResult && executeResult instanceof Boolean && ((Boolean)executeResult).booleanValue()) {
                if (!CollectionUtils.isEmpty((Collection)wordCapability.getEnabledAcCodes())) {
                    enabledAcCodes.addAll(wordCapability.getEnabledAcCodes());
                }
                if (!CollectionUtils.isEmpty((Collection)wordCapability.getDisabledAcCodes())) {
                    disabledAcCodes.addAll(wordCapability.getDisabledAcCodes());
                }
            }
        });
    }

    static {
        TAG_CATEGORY_LIST.put("POSITION", "\u63d0\u53d6\u5b57\u6bb5\u6807\u7b7e");
    }
}

