/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.impl;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcActivityData;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogData;
import com.digiwin.mobile.mobileuibot.proxy.atmc.service.DigiwinAtmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.audc.service.DigiwinAudcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotPageDefine;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotSubmitAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTaskPageDefine;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUibotSupportKeyConstant;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.TaskPageService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.analyzer.TaskPageDefineAnalyzer;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.template.TemplateService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.PcUiBotPatternUtil;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.PcUiBotSubmitActionUtil;
import com.digiwin.mobile.mobileuibot.sso.enums.SsoSourceTypeEnum;
import com.digiwin.mobile.mobileuibot.task.common.TaskStringUtil;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class TaskPageServiceImpl
implements TaskPageService,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(TaskPageServiceImpl.class);
    @Autowired
    private List<TemplateService<PcUiBotTaskPageDefine>> templateList;
    private final Map<String, TemplateService<PcUiBotTaskPageDefine>> templateContainer = new HashMap();
    @Autowired
    private TaskPageDefineAnalyzer taskPageDefineAnalyzer;
    @Autowired
    private DigiwinAtmcProxyService digiwinAtmcProxyService;
    @Autowired
    private DigiwinAudcProxyService digiwinAudcProxyService;

    public void afterPropertiesSet() throws Exception {
        if (this.templateList != null) {
            for (TemplateService template : this.templateList) {
                if (this.templateContainer.containsKey(template.supportKey())) {
                    throw new IllegalStateException("\u5b58\u5728\u91cd\u590d\u7684\u6a21\u677f\uff0c\u8bf7\u91cd\u4fee\u6539\u4ee3\u7801\uff1a" + template.supportKey());
                }
                this.templateContainer.put(template.supportKey(), template);
            }
        }
    }

    public UiBotModel createPage(PcUiBotExecuteContext executeContext, PcUiBotTaskPageDefine pageDefine, ApiRequest apiRequest) {
        this.appendUserOrderConditions(executeContext, pageDefine);
        if ("project-detail-mobile".equals(executeContext.getPageCode())) {
            if (!CollectionUtils.isEmpty((Collection)pageDefine.getSubmitActions()) && executeContext.isShared() && !executeContext.isOwnerBacklog()) {
                pageDefine.setSubmitActions(new ArrayList());
                pageDefine.setSubmitType(null);
            }
            if (pageDefine.getFinished() != null && !pageDefine.getFinished().booleanValue() && "completed".equals(pageDefine.getDataStateCode())) {
                pageDefine.setSubmitActions(PcUiBotSubmitActionUtil.onlyKeepAction((List)pageDefine.getSubmitActions()));
            }
        } else if (pageDefine.getFinished() != null && !pageDefine.getFinished().booleanValue() && "completed".equals(pageDefine.getDataStateCode())) {
            pageDefine.setSubmitActions(PcUiBotSubmitActionUtil.onlyKeepWithdrawAction((List)pageDefine.getSubmitActions()));
        }
        UiBotModel uiBotModel = null;
        TemplateService templateService = this.getTemplate(executeContext, pageDefine.getVersion(), pageDefine.getIsDesignerDsl());
        if (templateService != null) {
            uiBotModel = templateService.createPage(apiRequest, executeContext, (PcUiBotPageDefine)pageDefine, (List)Lists.newArrayList((Object[])new PcUiBotTaskPageDefine[]{pageDefine}));
        }
        if (uiBotModel == null) {
            return UiBotModel.emptyUiBotModel();
        }
        return uiBotModel;
    }

    private void appendUserOrderConditions(PcUiBotExecuteContext executeContext, PcUiBotTaskPageDefine pageDefine) {
        try {
            JSONObject orderSetting;
            if (executeContext.getIsDesigner() != null && executeContext.getIsDesigner().booleanValue()) {
                return;
            }
            if (executeContext.getOpenWindow() != null && (executeContext.getOpenWindow() == null || executeContext.getOpenWindow().booleanValue())) {
                return;
            }
            if (pageDefine == null) {
                return;
            }
            String schema = pageDefine.getDataSourceSet().getMainDatasource();
            if (schema == null) {
                return;
            }
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)executeContext.getTmActivityId())) {
                return;
            }
            String tmProjectId = "";
            tmProjectId = StringUtils.hasText((String)executeContext.getTmProjectId()) ? executeContext.getTmProjectId() : "__uibot__";
            JSONObject userSetting = this.digiwinAudcProxyService.getOrderConditionsByUser(executeContext.getLocale(), executeContext.getAuthoredUser().getToken(), executeContext.getTenantId(), executeContext.getPageCode(), tmProjectId, executeContext.getTmActivityId());
            if (userSetting == null || userSetting.isEmpty()) {
                return;
            }
            if (userSetting.containsKey((Object)"order") && !userSetting.containsKey((Object)schema)) {
                JSONObject setting = new JSONObject();
                setting.put(schema, (Object)userSetting);
                userSetting = setting;
            }
            if (userSetting != null && !userSetting.isEmpty() && (orderSetting = userSetting.getJSONObject(schema)).containsKey((Object)"order")) {
                pageDefine.setSortInfo(orderSetting.getJSONObject("order").getJSONArray("options"));
            }
            pageDefine.setUserSetting(userSetting);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public UiBotModel createPage(PcUiBotExecuteContext executeContext, String backlogId, ApiRequest apiRequest) {
        TemplateService templateService;
        executeContext.setIsDesigner(null);
        long start = System.currentTimeMillis();
        DigiwinAtmcActivityData activityData = this.digiwinAtmcProxyService.getTaskData(backlogId, executeContext);
        log.debug("[{}]\u83b7\u53d6\u4efb\u52a1\u6570\u636e\uff0ccost\uff1a{} ms", (Object)backlogId, (Object)(System.currentTimeMillis() - start));
        start = System.currentTimeMillis();
        executeContext.appendTaskData(activityData);
        List taskPageDefines = this.taskPageDefineAnalyzer.analysis(apiRequest, executeContext, activityData);
        if (taskPageDefines.size() > 1) {
            boolean isClosed = true;
            for (Object taskPageDefine : taskPageDefines) {
                if (taskPageDefine.getFinished() != null && !Boolean.FALSE.equals(taskPageDefine.getFinished())) continue;
                isClosed = false;
                break;
            }
            if (isClosed) {
                PcUiBotTaskPageDefine completedTaskPageDefine = null;
                for (PcUiBotTaskPageDefine taskPageDefine : taskPageDefines) {
                    if (!"completed".equals(taskPageDefine.getDataStateCode())) continue;
                    completedTaskPageDefine = taskPageDefine;
                }
                if (completedTaskPageDefine != null) {
                    taskPageDefines.remove(completedTaskPageDefine);
                    taskPageDefines.add(0, completedTaskPageDefine);
                }
            }
        }
        List<PcUiBotTaskPageDefine> taskPageDefineNews = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)taskPageDefines)) {
            if (executeContext.getTaskWithBacklogData() != null && executeContext.getTaskWithBacklogData().getBpmData() != null && executeContext.getTaskWithBacklogData().getBpmData().containsKey("uibot__dataStateCodes")) {
                List dataStateCodes = (List)JsonUtil.objectToJavaObject(executeContext.getTaskWithBacklogData().getBpmData().get("uibot__dataStateCodes"), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
                for (PcUiBotTaskPageDefine taskPageDefine : taskPageDefines) {
                    if (!dataStateCodes.contains(taskPageDefine.getDataStateCode())) continue;
                    taskPageDefineNews.add(taskPageDefine);
                }
            } else {
                taskPageDefineNews = taskPageDefines;
            }
            if (CollectionUtils.isEmpty(taskPageDefineNews)) {
                taskPageDefineNews = taskPageDefines;
            }
        }
        log.debug("[{}]\u89e3\u6790\u9875\u9762\u5b9a\u4e49\uff0ccost\uff1a{} ms", (Object)backlogId, (Object)(System.currentTimeMillis() - start));
        start = System.currentTimeMillis();
        UiBotModel uiBotModel = null;
        if (!CollectionUtils.isEmpty(taskPageDefineNews) && (templateService = this.getTemplate(executeContext, ((PcUiBotTaskPageDefine)taskPageDefineNews.get(0)).getVersion(), ((PcUiBotTaskPageDefine)taskPageDefineNews.get(0)).getIsDesignerDsl())) != null) {
            uiBotModel = templateService.createTaskPage(apiRequest, executeContext, (PcUiBotPageDefine)taskPageDefineNews.get(0), taskPageDefineNews);
            if (taskPageDefineNews.size() > 1) {
                PcUiBotTaskPageDefine taskPageDefineFirst = (PcUiBotTaskPageDefine)taskPageDefineNews.get(0);
                if (BooleanUtils.isTrue((Boolean)taskPageDefineFirst.getFinished()) && "completed".equals(taskPageDefineFirst.getDataStateCode())) {
                    this.setFinishedValue(executeContext, taskPageDefineNews, uiBotModel);
                }
            } else if (!CollectionUtils.isEmpty(taskPageDefineNews) && BooleanUtils.isTrue((Boolean)((PcUiBotTaskPageDefine)taskPageDefineNews.get(0)).getFinished())) {
                this.setFinishedValue(executeContext, taskPageDefineNews, uiBotModel);
            }
            if (!(ObjectUtils.isEmpty((Object)uiBotModel.getFinished()) || !uiBotModel.getFinished().booleanValue() || TaskStringUtil.isBizApproval((String)executeContext.getPattern(), (String)executeContext.getCategory()) || TaskStringUtil.isBizDataEntryDriven((String)executeContext.getPattern(), (String)executeContext.getCategory()) || TaskStringUtil.isBizSmartAdjust((String)executeContext.getTmActivityId()) || SsoSourceTypeEnum.NANA_MESSAGE.getSource().equals(apiRequest.getSourceType()))) {
                return UiBotModel.workReminderEmptyImageUibotModelV2((String)apiRequest.getLocale());
            }
        }
        log.debug("[{}]\u521b\u5efa\u9875\u9762\uff0ccost\uff1a{} ms", (Object)backlogId, (Object)(System.currentTimeMillis() - start));
        if (uiBotModel == null) {
            return UiBotModel.emptyUiBotModel();
        }
        if (!CollectionUtils.isEmpty(taskPageDefineNews)) {
            for (PcUiBotTaskPageDefine taskPageDefineNew : taskPageDefineNews) {
                taskPageDefineNew.setExecuteContext(null);
            }
        }
        return uiBotModel;
    }

    private void setFinishedValue(PcUiBotExecuteContext executeContext, List<PcUiBotTaskPageDefine> taskPageDefineNews, UiBotModel uiBotModel) {
        if (taskPageDefineNews.get(0).getSubmitActions() != null) {
            for (PcUiBotSubmitAction submitAction : taskPageDefineNews.get(0).getSubmitActions()) {
                if (this.isRetriveAction(submitAction)) {
                    PcUiBotSubmitAction retriveAction = this.getRetriveAction(submitAction);
                    if (retriveAction == null) continue;
                    uiBotModel.setFinished(Boolean.valueOf(false));
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    List backlog = Optional.ofNullable(executeContext.getTaskWithBacklogData().getBacklog()).orElse(new ArrayList());
                    List backlogIds = backlog.stream().map(DigiwinAtmcBacklogData::getBacklogId).collect(Collectors.toList());
                    map.put("workItemIdList", backlogIds);
                    String performerId = ((DigiwinAtmcBacklogData)backlog.get(0)).getPerformerId();
                    map.put("performerId", performerId);
                    map.put("performerType", 0);
                    map.put("agentPerformerId", "");
                    if (!Objects.equals(performerId, executeContext.getAuthoredUser().getUserId())) {
                        map.put("performerType", 1);
                        map.put("agentPerformerId", executeContext.getAuthoredUser().getUserId());
                    }
                    retriveAction.setParas(map);
                    continue;
                }
                if (!PcUiBotSubmitActionUtil.isTaskWithdrawAction((PcUiBotSubmitAction)submitAction)) continue;
                uiBotModel.setFinished(Boolean.valueOf(false));
                uiBotModel.setFinishedTitle(null);
            }
        }
    }

    private boolean isRetriveAction(PcUiBotSubmitAction tmAction) {
        if (tmAction == null) {
            return false;
        }
        if ("uibot_retrive".equals(tmAction.getActionId())) {
            return true;
        }
        if (!CollectionUtils.isEmpty((Collection)tmAction.getAttachActions())) {
            for (PcUiBotSubmitAction attachAction : tmAction.getAttachActions()) {
                if (!this.isRetriveAction(attachAction)) continue;
                return true;
            }
        }
        return false;
    }

    private PcUiBotSubmitAction getRetriveAction(PcUiBotSubmitAction tmAction) {
        if (tmAction == null) {
            return null;
        }
        if ("uibot_retrive".equals(tmAction.getActionId())) {
            return tmAction;
        }
        if (!CollectionUtils.isEmpty((Collection)tmAction.getAttachActions())) {
            for (PcUiBotSubmitAction attachAction : tmAction.getAttachActions()) {
                PcUiBotSubmitAction retriveAction = this.getRetriveAction(attachAction);
                if (retriveAction == null) continue;
                return retriveAction;
            }
        }
        return null;
    }

    private TemplateService<PcUiBotTaskPageDefine> getTemplate(PcUiBotExecuteContext executeContext, String version, Boolean isDesignerDsl) {
        if (BooleanUtils.isFalse((Boolean)isDesignerDsl)) {
            String templateName = "webplatform-business_assistan-assistan-performer";
            return (TemplateService)this.templateContainer.get(templateName);
        }
        if (PcUiBotPatternUtil.isModelDriven((PcUiBotExecuteContext)executeContext)) {
            String templateName = PcUibotSupportKeyConstant.Designer.BUSINESS_DATA_ENTRY_DRIVEN;
            return (TemplateService)this.templateContainer.get(templateName);
        }
        if (TaskStringUtil.isBizApproval((String)executeContext.getPattern(), (String)executeContext.getCategory())) {
            String templateName = "webplatform-business-designer-approval-performer";
            return (TemplateService)this.templateContainer.get(templateName);
        }
        String templateName = "webplatform-business-process-performer-2.0";
        return (TemplateService)this.templateContainer.get(templateName);
    }

    public UiBotModel createManuaTaskPage(PcUiBotExecuteContext executeContext, String backlogId) {
        return UiBotModel.emptyUiBotModel();
    }
}

