/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.proxy.zhilink.modelbuild;

import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.file.FileUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.basic.Field;
import com.digiwin.mobile.mobileuibot.core.component.basic.FieldAlignmentTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.basic.Tag;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroup;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroupContent;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroupStyleTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.list.multi.MultiFunctionList;
import com.digiwin.mobile.mobileuibot.core.component.list.multi.MultiFunctionListChoiceEnum;
import com.digiwin.mobile.mobileuibot.core.component.list.multi.MultiFunctionListStyleTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.list.pageable.PageableList;
import com.digiwin.mobile.mobileuibot.core.component.title.TitleLabelPositionEnum;
import com.digiwin.mobile.mobileuibot.core.component.title.titlebody.TitleBody;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.util.ModuleUtils;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogDetail;
import com.digiwin.mobile.mobileuibot.proxy.atmc.service.DigiwinAtmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.esp.service.DigiwinEspProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotActionSubmitType;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.service.DigiwinPcUiBotProxyService;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;

@Component(value="uiBotModelBuildZTBGoodsLoadingStrategy")
public class UiBotModelBuildZTBGoodsLoadingStrategy
implements UiBotModelBuildStrategy {
    private static final Logger logger = LoggerFactory.getLogger(UiBotModelBuildZTBGoodsLoadingStrategy.class);
    @Autowired
    private DigiwinEspProxyService digiwinEspProxyService;
    @Autowired
    private DigiwinAtmcProxyService digiwinAtmcProxyService;
    @Autowired
    private DigiwinPcUiBotProxyService digiwinPcUiBotProxyService;
    @Autowired
    private LocaleService localeService;

    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        StopWatch stopWatch = new StopWatch("BuildZTBGoodsLoading");
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel = useMockData == false && modelTypeShow == false ? this.doActually(pageSetting, apiRequest, stopWatch) : this.doMockData(pageSetting, apiRequest);
        logger.debug(stopWatch.prettyPrint());
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest, StopWatch stopWatch) {
        UiBotModel uiBotModel = pageSetting.getPageModel();
        UiBotPageData pageData = uiBotModel.getPageData();
        String locale = apiRequest.getLocale();
        String iamUserToken = apiRequest.getIamUserToken();
        String tenantId = apiRequest.getTenantId();
        String dataId = apiRequest.getDataId();
        DigiwinAtmcBacklogDetail digiwinAtmcBacklogDetail = this.digiwinAtmcProxyService.getDigiwinAtmcBacklogDetailByShare(locale, iamUserToken, dataId);
        String tmTaskId = "";
        String tmActivityId = "";
        if (null != apiRequest.getExtraParameter()) {
            tmTaskId = apiRequest.getExtraParameter().getTmTaskId();
            tmActivityId = apiRequest.getExtraParameter().getTmActivityId();
        } else {
            tmTaskId = digiwinAtmcBacklogDetail.getTmTaskId();
            tmActivityId = digiwinAtmcBacklogDetail.getTmActivityId();
        }
        ApiRawData apiRawData = apiRequest.getRawData() != null ? apiRequest.getRawData() : new ApiRawData();
        apiRawData.put("digi-proxy-token", (Object)digiwinAtmcBacklogDetail.getProxyToken());
        this.digiwinAtmcProxyService.updateDigiwinAtmcBacklogReadCount(locale, iamUserToken, tenantId, dataId);
        UiBotModel pcUiBotModel = this.digiwinPcUiBotProxyService.getTaskTemplateShowByBacklogId(locale, iamUserToken, tenantId, dataId, tmTaskId, tmActivityId, apiRawData);
        if (ObjectUtils.isNotEmpty((Object)pcUiBotModel.getFinished()) && pcUiBotModel.getFinished().booleanValue()) {
            return UiBotModel.workReminderEmptyImageUibotModel((String)apiRequest.getLocale());
        }
        String taskNo = "";
        List deliveryDetail = (List)pcUiBotModel.getPageData().get((Object)"delivery_detail");
        if (!CollectionUtils.isEmpty((Collection)deliveryDetail)) {
            taskNo = String.valueOf(((Map)deliveryDetail.get(0)).get("task_no"));
        }
        stopWatch.start("Build ZTBGoodsLoading Detail Page Model...");
        List uiBotLayouts = uiBotModel.getLayout();
        UiBotPageData newPageData = new UiBotPageData();
        for (UiBotLayout layout : uiBotLayouts) {
            String schema = layout.getSchema();
            switch (layout.getType()) {
                case "TITLE_BODY": {
                    TitleBody titleBody = TitleBody.create((String)locale, (DigiwinAtmcBacklogDetail)digiwinAtmcBacklogDetail);
                    titleBody.setLabelPosition(TitleLabelPositionEnum.DOWN_TO_TITLE.getPosition());
                    newPageData.put((Object)schema, (Object)titleBody);
                    List tags = titleBody.getTags();
                    Tag qrCodeTag = Tag.createBlueBgdWriteTextStateTag((String)(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u8d27\u8fd0\u4e8c\u7ef4\u7801") + ">"));
                    qrCodeTag.setLabelPosition(TitleLabelPositionEnum.RIGHT_TO_TITLE.getPosition());
                    Action qrCodeAction = new Action();
                    qrCodeAction.setType(ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM.getValue());
                    qrCodeAction.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ZTB_SHIPPING_TASK_QR_CODE.toString());
                    qrCodeAction.setJumpPageTitle(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u8d27\u8fd0\u4e8c\u7ef4\u7801"));
                    qrCodeAction.setDataId(taskNo);
                    qrCodeTag.setAction(qrCodeAction);
                    HashMap<String, String> qrCodeActionRawData = new HashMap<String, String>();
                    qrCodeActionRawData.put("task_no", taskNo);
                    qrCodeAction.setRawData(qrCodeActionRawData);
                    tags.add(qrCodeTag);
                    titleBody.setTags(tags);
                    break;
                }
                case "MULTI_FUNCTION_LIST": {
                    MultiFunctionList multiFunctionList = (MultiFunctionList)JsonUtil.objectToJavaObject((Object)pageData.get((Object)schema), MultiFunctionList.class);
                    multiFunctionList.setChoice(MultiFunctionListChoiceEnum.MULTIPLE_CHOICE.toString());
                    multiFunctionList.setPageable(Boolean.valueOf(true));
                    multiFunctionList.setTitle(this.localeService.getLanguageValue(locale, multiFunctionList.getTitle()));
                    multiFunctionList.setSearch(Boolean.valueOf(false));
                    multiFunctionList.setDataUrl("/mobile/v1/ztb/cargo/information");
                    multiFunctionList.setStyleType(MultiFunctionListStyleTypeEnum.CARD.toString());
                    ApiRawData rawData = new ApiRawData();
                    rawData.put("task_no", (Object)taskNo);
                    rawData.put("isLoadCar", (Object)true);
                    multiFunctionList.setRawData(rawData);
                    newPageData.put((Object)schema, (Object)multiFunctionList);
                    break;
                }
                case "BOTTOM_BUTTON": {
                    List buttons = ModuleUtils.listMapToListObject((List)((List)pageData.get((Object)schema)), BottomButtonDigiwinAthena.class);
                    for (BottomButtonDigiwinAthena bottomButton : buttons) {
                        bottomButton.setName(this.localeService.getLanguageValue(locale, bottomButton.getName()));
                        if (bottomButton.getAction() == null) continue;
                        Action action = bottomButton.getAction();
                        ApiRawData buttonRawData = new ApiRawData();
                        buttonRawData.put("task_no", (Object)taskNo);
                        buttonRawData.put("biz_id", (Object)"ZTB");
                        buttonRawData.put("digi-proxy-token", (Object)digiwinAtmcBacklogDetail.getProxyToken());
                        buttonRawData.put("page_id", (Object)PageSettingIdPresetEnum.MOBILE_ZTB_GOODS_LOADING.toString());
                        UiBotAction uiBotAction = this.getSubmitAction(pcUiBotModel, "submit-data");
                        if (null != uiBotAction) {
                            buttonRawData.put("action", (Object)uiBotAction);
                            HashMap<String, Object> data = new HashMap<String, Object>();
                            String actionDataScheme = Optional.ofNullable(uiBotAction.getSubmitType()).orElse(new UiBotActionSubmitType()).getSchema();
                            data.put(actionDataScheme, pcUiBotModel.getPageData().get((Object)actionDataScheme));
                            buttonRawData.put("data", data);
                        }
                        action.setRawData((Object)buttonRawData);
                    }
                    newPageData.put((Object)schema, (Object)buttons);
                    break;
                }
            }
        }
        stopWatch.stop();
        uiBotModel.setPageData(newPageData);
        return uiBotModel;
    }

    private CustomGroup buildDriverMessageGroup(String locale, List<Map<String, Object>> vehicleInfo, UiBotModel driverMessageUiBotModel) {
        CustomGroup customGroup = new CustomGroup();
        List driverMessageLayouts = driverMessageUiBotModel.getLayout();
        UiBotPageData pageData = driverMessageUiBotModel.getPageData();
        UiBotPageData driverMessagePageData = new UiBotPageData();
        for (UiBotLayout driverMessageLayout : driverMessageLayouts) {
            String driverMessageSchema = driverMessageLayout.getSchema();
            Map schemaPageData = (Map)pageData.get((Object)driverMessageSchema);
            switch (driverMessageLayout.getType()) {
                case "FIELD": {
                    Field driverMessageField = new Field();
                    String value = "-";
                    if (!CollectionUtils.isEmpty(vehicleInfo)) {
                        value = String.valueOf(vehicleInfo.get(0).get(driverMessageSchema));
                    }
                    driverMessageField = Field.create((String)((String)driverMessageLayout.getmLabelText().get(locale)), (String)"LABEL", (String)value, (String)driverMessageSchema, (Integer)FieldAlignmentTypeEnum.LABEL_LEFT_VALUE_LEFT.getValue());
                    driverMessagePageData.put((Object)driverMessageSchema, (Object)driverMessageField);
                    break;
                }
            }
        }
        CustomGroupContent driverMessageContent = new CustomGroupContent();
        driverMessageContent.setLayout(driverMessageLayouts);
        driverMessageContent.setPageData(driverMessagePageData);
        customGroup.setContent(driverMessageContent);
        customGroup.setName(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u8f66\u8f86\u4fe1\u606f"));
        customGroup.setStyleType(CustomGroupStyleTypeEnum.STYLE_ZTB_SCAN_RECEIVE.getValue());
        return customGroup;
    }

    private CustomGroup buildDriverInfoGroup(String locale, List<Map<String, Object>> vehicleInfo, UiBotModel driverInfoUiBotModel) {
        CustomGroup customGroup = new CustomGroup();
        List driverInfoLayouts = driverInfoUiBotModel.getLayout();
        UiBotPageData pageData = driverInfoUiBotModel.getPageData();
        UiBotPageData driverInfoPageData = new UiBotPageData();
        for (UiBotLayout driverInfoLayout : driverInfoLayouts) {
            String driverInfoSchema = driverInfoLayout.getSchema();
            Map schemaPageData = (Map)pageData.get((Object)driverInfoSchema);
            switch (driverInfoLayout.getType()) {
                case "FIELD": {
                    Field driverInfoField = new Field();
                    String value = "-";
                    if (!CollectionUtils.isEmpty(vehicleInfo)) {
                        value = String.valueOf(vehicleInfo.get(0).get(driverInfoSchema));
                    }
                    String fieldType = "LABEL";
                    if ("driver_mobile".equalsIgnoreCase(driverInfoSchema)) {
                        fieldType = "PHONE";
                    }
                    driverInfoField = Field.create((String)((String)driverInfoLayout.getmLabelText().get(locale)), (String)fieldType, (String)value, (String)driverInfoSchema, (Integer)FieldAlignmentTypeEnum.LABEL_LEFT_VALUE_LEFT.getValue());
                    driverInfoPageData.put((Object)driverInfoSchema, (Object)driverInfoField);
                    break;
                }
            }
        }
        CustomGroupContent driverInfoContent = new CustomGroupContent();
        driverInfoContent.setLayout(driverInfoLayouts);
        driverInfoContent.setPageData(driverInfoPageData);
        customGroup.setContent(driverInfoContent);
        customGroup.setName(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u53f8\u673a\u4fe1\u606f"));
        customGroup.setStyleType(CustomGroupStyleTypeEnum.STYLE_ZTB_SCAN_RECEIVE.getValue());
        return customGroup;
    }

    private CustomGroup buildFreightGroup(String locale, String taskNo, UiBotModel freightUiBotModel) {
        CustomGroup customGroup = new CustomGroup();
        List freightLayouts = freightUiBotModel.getLayout();
        UiBotPageData pageData = freightUiBotModel.getPageData();
        UiBotPageData freightPageData = new UiBotPageData();
        for (UiBotLayout freightLayout : freightLayouts) {
            String freightSchema = freightLayout.getSchema();
            Map schemaPageData = (Map)pageData.get((Object)freightSchema);
            switch (freightLayout.getType()) {
                case "PAGEABLE_LIST": {
                    PageableList freightPageableList = new PageableList();
                    HashMap<String, Object> rawData = new HashMap<String, Object>();
                    rawData.put("task_no", taskNo);
                    rawData.put("use_has_next", true);
                    freightPageableList = PageableList.create(rawData, (String)"/mobile/v1/uibot/component/pageablelist/data", (String)"");
                    freightPageData.put((Object)freightSchema, (Object)freightPageableList);
                    break;
                }
            }
        }
        CustomGroupContent freightContent = new CustomGroupContent();
        freightContent.setLayout(freightLayouts);
        freightContent.setPageData(freightPageData);
        customGroup.setContent(freightContent);
        customGroup.setName(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u8d27\u7269\u4fe1\u606f"));
        return customGroup;
    }

    private UiBotAction getSubmitAction(UiBotModel pcUiBotModel, String actionId) {
        List layoutList = pcUiBotModel.getLayout();
        if (CollectionUtils.isEmpty((Collection)layoutList)) {
            return null;
        }
        AtomicReference<UiBotAction> uiBotAction = new AtomicReference<UiBotAction>();
        block0: for (UiBotLayout layout : layoutList) {
            List actions = layout.getActions();
            if (CollectionUtils.isEmpty((Collection)actions)) continue;
            for (UiBotAction action : actions) {
                if (!actionId.equalsIgnoreCase(action.getActionId())) continue;
                uiBotAction.set(action);
                break block0;
            }
        }
        return (UiBotAction)uiBotAction.get();
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        UiBotModel uiBotModel = null;
        String data = FileUtil.readText((String)"static/.json");
        if (null != data && !data.isEmpty()) {
            uiBotModel = (UiBotModel)JsonUtil.jsonStringToObject((String)data, UiBotModel.class);
        }
        return uiBotModel;
    }
}

