/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.recommend.rule.params;

import com.alibaba.fastjson.annotation.JSONField;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppEnvDeployAreaEnum;
import com.digiwin.mobile.mobileuibot.recommend.rule.RecommendMobileConfig;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class PurchasedGoodsEnableModule
implements Serializable {
    private static final long serialVersionUID = -962849283387234341L;
    private String moduleId;
    private String workId;
    private Boolean valid;
    private Boolean verify;
    private RecommendMobileConfig mobileConfig;
    private String type;
    @JsonProperty(value="CN")
    @JSONField(name="CN")
    private List<PurchasedGoodsEnableModule> cn;
    @JsonProperty(value="TW")
    @JSONField(name="TW")
    private List<PurchasedGoodsEnableModule> tw;

    public void convert() {
        String envDeployArea = AppContext.getEnvDeployArea();
        if (AppEnvDeployAreaEnum.CN.name().equals(envDeployArea)) {
            this.convertDefaultByArea(this.cn);
        } else if (AppEnvDeployAreaEnum.TW.name().equals(envDeployArea)) {
            this.convertDefaultByArea(this.tw);
        }
    }

    private void convertDefaultByArea(List<PurchasedGoodsEnableModule> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        String envType = AppContext.getEnvType();
        Optional<PurchasedGoodsEnableModule> optional = list.stream().filter(r -> StringUtils.hasLength((String)r.getType()) && r.getType().equals(envType)).findFirst();
        if (!optional.isPresent()) {
            return;
        }
        PurchasedGoodsEnableModule enableModule = optional.get();
        if (null != enableModule.getValid()) {
            this.valid = enableModule.getValid();
        }
        if (null != enableModule.getVerify()) {
            this.verify = enableModule.getVerify();
        }
        if (null != enableModule.getMobileConfig()) {
            if (null == this.mobileConfig) {
                this.mobileConfig = new RecommendMobileConfig();
            }
            this.mobileConfig.convert(enableModule.getMobileConfig());
        }
    }

    public String getModuleId() {
        return this.moduleId;
    }

    public String getWorkId() {
        return this.workId;
    }

    public Boolean getValid() {
        return this.valid;
    }

    public Boolean getVerify() {
        return this.verify;
    }

    public RecommendMobileConfig getMobileConfig() {
        return this.mobileConfig;
    }

    public String getType() {
        return this.type;
    }

    public List<PurchasedGoodsEnableModule> getCn() {
        return this.cn;
    }

    public List<PurchasedGoodsEnableModule> getTw() {
        return this.tw;
    }

    public void setModuleId(String moduleId) {
        this.moduleId = moduleId;
    }

    public void setWorkId(String workId) {
        this.workId = workId;
    }

    public void setValid(Boolean valid) {
        this.valid = valid;
    }

    public void setVerify(Boolean verify) {
        this.verify = verify;
    }

    public void setMobileConfig(RecommendMobileConfig mobileConfig) {
        this.mobileConfig = mobileConfig;
    }

    public void setType(String type) {
        this.type = type;
    }

    @JsonProperty(value="CN")
    public void setCn(List<PurchasedGoodsEnableModule> cn) {
        this.cn = cn;
    }

    @JsonProperty(value="TW")
    public void setTw(List<PurchasedGoodsEnableModule> tw) {
        this.tw = tw;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PurchasedGoodsEnableModule)) {
            return false;
        }
        PurchasedGoodsEnableModule other = (PurchasedGoodsEnableModule)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$valid = this.getValid();
        Boolean other$valid = other.getValid();
        if (this$valid == null ? other$valid != null : !((Object)this$valid).equals(other$valid)) {
            return false;
        }
        Boolean this$verify = this.getVerify();
        Boolean other$verify = other.getVerify();
        if (this$verify == null ? other$verify != null : !((Object)this$verify).equals(other$verify)) {
            return false;
        }
        String this$moduleId = this.getModuleId();
        String other$moduleId = other.getModuleId();
        if (this$moduleId == null ? other$moduleId != null : !this$moduleId.equals(other$moduleId)) {
            return false;
        }
        String this$workId = this.getWorkId();
        String other$workId = other.getWorkId();
        if (this$workId == null ? other$workId != null : !this$workId.equals(other$workId)) {
            return false;
        }
        RecommendMobileConfig this$mobileConfig = this.getMobileConfig();
        RecommendMobileConfig other$mobileConfig = other.getMobileConfig();
        if (this$mobileConfig == null ? other$mobileConfig != null : !this$mobileConfig.equals(other$mobileConfig)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        List this$cn = this.getCn();
        List other$cn = other.getCn();
        if (this$cn == null ? other$cn != null : !((Object)this$cn).equals(other$cn)) {
            return false;
        }
        List this$tw = this.getTw();
        List other$tw = other.getTw();
        return !(this$tw == null ? other$tw != null : !((Object)this$tw).equals(other$tw));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PurchasedGoodsEnableModule;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $valid = this.getValid();
        result = result * 59 + ($valid == null ? 43 : ((Object)$valid).hashCode());
        Boolean $verify = this.getVerify();
        result = result * 59 + ($verify == null ? 43 : ((Object)$verify).hashCode());
        String $moduleId = this.getModuleId();
        result = result * 59 + ($moduleId == null ? 43 : $moduleId.hashCode());
        String $workId = this.getWorkId();
        result = result * 59 + ($workId == null ? 43 : $workId.hashCode());
        RecommendMobileConfig $mobileConfig = this.getMobileConfig();
        result = result * 59 + ($mobileConfig == null ? 43 : $mobileConfig.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        List $cn = this.getCn();
        result = result * 59 + ($cn == null ? 43 : ((Object)$cn).hashCode());
        List $tw = this.getTw();
        result = result * 59 + ($tw == null ? 43 : ((Object)$tw).hashCode());
        return result;
    }

    public String toString() {
        return "PurchasedGoodsEnableModule(moduleId=" + this.getModuleId() + ", workId=" + this.getWorkId() + ", valid=" + this.getValid() + ", verify=" + this.getVerify() + ", mobileConfig=" + this.getMobileConfig() + ", type=" + this.getType() + ", cn=" + this.getCn() + ", tw=" + this.getTw() + ")";
    }

    public PurchasedGoodsEnableModule() {
    }

    public PurchasedGoodsEnableModule(String moduleId, String workId, Boolean valid, Boolean verify, RecommendMobileConfig mobileConfig, String type, List<PurchasedGoodsEnableModule> cn, List<PurchasedGoodsEnableModule> tw) {
        this.moduleId = moduleId;
        this.workId = workId;
        this.valid = valid;
        this.verify = verify;
        this.mobileConfig = mobileConfig;
        this.type = type;
        this.cn = cn;
        this.tw = tw;
    }
}

