/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.task.strategy;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.UiBotModelBuildService;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.action.PopPromptMsg;
import com.digiwin.mobile.mobileuibot.core.component.business.bizapproval.BizApprovalTabBuilder;
import com.digiwin.mobile.mobileuibot.core.component.business.bizapproval.BizApprovalTabList;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonBizApprovalBuilder;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonList;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonStyleEnum;
import com.digiwin.mobile.mobileuibot.core.component.button.Button;
import com.digiwin.mobile.mobileuibot.core.component.card.cardone.CardOne;
import com.digiwin.mobile.mobileuibot.core.component.card.cardone.CardOneBizApprovalBuilder;
import com.digiwin.mobile.mobileuibot.core.component.navbar.pagedesc.PageDesc;
import com.digiwin.mobile.mobileuibot.core.component.navbar.pagedesc.PageDescBuilderFactory;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtab.CustomTabScrollModeEnum;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.util.ModuleUtils;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogDetail;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotTargetLayoutSearchResult;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.task.common.TaskDataExtractUtil;
import com.digiwin.mobile.mobileuibot.task.model.TaskDetail;
import com.digiwin.mobile.mobileuibot.task.model.TaskDetailBizApproval;
import com.digiwin.mobile.mobileuibot.task.strategy.TaskDetailBuildStrategy;
import io.micrometer.core.instrument.util.StringUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

@Component
public class TaskDetailBuildBizDataEntryDrivenStrategy
implements TaskDetailBuildStrategy {
    private static final Logger log = LoggerFactory.getLogger(TaskDetailBuildBizDataEntryDrivenStrategy.class);
    @Autowired
    private PageDescBuilderFactory pageDescBuilderFactory;
    @Autowired
    private CardOneBizApprovalBuilder cardOneBizApprovalBuilder;
    @Autowired
    private BizApprovalTabBuilder bizApprovalTabBuilder;
    @Autowired
    private BottomButtonBizApprovalBuilder bottomButtonBizApprovalBuilder;
    @Autowired
    private UiBotModelBuildService uiBotModelBuildService;
    @Autowired
    private LocaleService localeService;

    public String getTaskDetailType() {
        return "BUSINESS_DATA_ENTRY_DRIVEN";
    }

    public TaskDetail build(ApiRequest apiRequest, PageSetting pageSetting, UiBotModel pcUiBotModel, Object ... args) {
        UiBotModel pageModel = pageSetting.getPageModel();
        TaskDetailBizApproval taskDetailBizApproval = new TaskDetailBizApproval();
        for (UiBotLayout layout : pageModel.getLayout()) {
            String layoutType;
            switch (layoutType = layout.getType()) {
                case "TITLE_BODY": {
                    taskDetailBizApproval.put((Object)layout.getSchema(), (Object)ModuleUtils.buildTitle((UiBotModel)pcUiBotModel, (Map)pcUiBotModel.getPageData(), (DigiwinAtmcBacklogDetail)((DigiwinAtmcBacklogDetail)args[0]), (ApiRequest)apiRequest, (Boolean)true, (Boolean)true));
                    break;
                }
                case "PAGE_DESC": {
                    taskDetailBizApproval.put((Object)layout.getSchema(), (Object)this.pageDescBuilderFactory.get("BUSINESS_APPROVAL").build(apiRequest, pageSetting, pcUiBotModel, PageDesc.class, args));
                    break;
                }
                case "CARD_ONE": {
                    taskDetailBizApproval.put((Object)layout.getSchema(), (Object)this.cardOneBizApprovalBuilder.build(apiRequest, pageSetting, pcUiBotModel, CardOne.class, args));
                    break;
                }
                case "TABS": {
                    BizApprovalTabList tabs = this.bizApprovalTabBuilder.buildAllTabs(apiRequest, pcUiBotModel);
                    tabs.forEach(tab -> tab.setMScrollMode(CustomTabScrollModeEnum.NO_SCROLL.getMode()));
                    taskDetailBizApproval.put((Object)layout.getSchema(), (Object)tabs);
                    break;
                }
                case "BOTTOM_BUTTON": {
                    break;
                }
            }
        }
        return taskDetailBizApproval;
    }

    public BottomButtonList buildUserTaskButton(String schema, ApiRequest apiRequest, PageSetting pageSetting, UiBotModel pcUiBotModel, Object[] args) {
        String locale = apiRequest.getLocale();
        List uiBotActions = pcUiBotModel.getActions();
        if (null == uiBotActions || uiBotActions.isEmpty()) {
            return BottomButtonList.createEmpty();
        }
        String bizDataSchema = "";
        UiBotTargetLayoutSearchResult layoutSearchResult = pcUiBotModel.searchPcTargetLayout();
        if (!layoutSearchResult.found()) {
            return BottomButtonList.createEmpty();
        }
        bizDataSchema = layoutSearchResult.getTargetUiBotLayout().getSchema();
        Object bizData = pcUiBotModel.getPageData().get((Object)bizDataSchema);
        if (bizData == null) {
            return BottomButtonList.createEmpty();
        }
        if (bizData instanceof List && ((List)bizData).isEmpty()) {
            return BottomButtonList.createEmpty();
        }
        if (bizData instanceof Map && ((Map)bizData).isEmpty()) {
            return BottomButtonList.createEmpty();
        }
        BottomButtonList result = new BottomButtonList();
        HashMap<String, UiBotAction> allActionMap = new HashMap<String, UiBotAction>();
        for (UiBotAction uiBotAction : uiBotActions) {
            String serviceIdName;
            if (uiBotAction.isAgreeAction(serviceIdName = uiBotAction.getActionServiceIdName())) {
                allActionMap.put("workflow-act-agree", uiBotAction);
                continue;
            }
            String targetServiceIdName = uiBotAction.getUsefulActionServiceIdName();
            if (uiBotAction.isAgreeAction(targetServiceIdName)) {
                allActionMap.put("workflow-act-agree", uiBotAction);
                continue;
            }
            allActionMap.put(targetServiceIdName, uiBotAction);
        }
        UiBotModel pageSettingModel = pageSetting.getPageModel();
        String bottomButtonDataSchema = schema;
        UiBotPageData pageData = pageSettingModel.getPageData();
        JSONArray bottomButtonDataArray = (JSONArray)JSON.toJSON(pageData.get(bottomButtonDataSchema));
        String appCode = null;
        if (!ObjectUtils.isEmpty((Object[])args)) {
            DigiwinAtmcBacklogDetail digiwinAtmcBacklogDetail = (DigiwinAtmcBacklogDetail)args[0];
            appCode = digiwinAtmcBacklogDetail.getAppCode();
        }
        for (int i = 0; i < bottomButtonDataArray.size(); ++i) {
            BottomButtonDigiwinAthena bottomButton;
            JSONObject bottomButtonJsonObj = bottomButtonDataArray.getJSONObject(i);
            String id = bottomButtonJsonObj.getString("id");
            if ("other".equalsIgnoreCase(id)) {
                bottomButton = BottomButtonDigiwinAthena.create((Integer)BottomButtonStyleEnum.NORMAL.getValue(), (String)"...");
            } else if ("redo".equalsIgnoreCase(id)) {
                bottomButton = BottomButtonDigiwinAthena.create((Integer)BottomButtonStyleEnum.NORMAL.getValue(), (String)LocaleUtil.getMobileTextByKey((String)locale, (String)"\u9000\u56de"));
            } else {
                UiBotAction pcUiBotAction = (UiBotAction)allActionMap.get(id);
                if (null == pcUiBotAction) continue;
                JSONObject buttonActionJsonObj = bottomButtonJsonObj.getJSONObject("action");
                String jumpPageId = buttonActionJsonObj.getString("jumpPageId");
                Integer buttonType = buttonActionJsonObj.getInteger("type");
                bottomButton = BottomButtonDigiwinAthena.create((UiBotAction)pcUiBotAction, (String)bizDataSchema, (Object)bizData, null, (Action)new Action(jumpPageId, LocaleUtil.getMobileTextByKey((String)locale, (String)jumpPageId), buttonType), (Integer)bottomButtonJsonObj.getInteger("iconData"), (String)id, (String)appCode);
            }
            JSONArray childrenBottomButtonArray = bottomButtonJsonObj.getJSONArray("children");
            for (int j = 0; null != childrenBottomButtonArray && j < childrenBottomButtonArray.size(); ++j) {
                JSONObject childBottomButtonJsonObj = childrenBottomButtonArray.getJSONObject(j);
                String childBottomButtonId = childBottomButtonJsonObj.getString("id");
                UiBotAction childUiBotAction = (UiBotAction)allActionMap.get(childBottomButtonId);
                if (null == childUiBotAction) continue;
                JSONObject childBottomButtonActionJsonObj = childBottomButtonJsonObj.getJSONObject("action");
                String jumpPageId = childBottomButtonActionJsonObj.getString("jumpPageId");
                String jumpPageTitle = childBottomButtonActionJsonObj.getString("jumpPageTitle");
                Integer buttonType = childBottomButtonActionJsonObj.getInteger("type");
                if (StringUtils.isBlank((String)(jumpPageTitle = LocaleUtil.getMobileTextByKey((String)locale, (String)jumpPageTitle)))) {
                    jumpPageTitle = LocaleUtil.getMobileTextByKey((String)locale, (String)jumpPageId);
                }
                Action childBottomButtonAction = new Action(jumpPageId, jumpPageTitle, buttonType);
                BottomButtonDigiwinAthena childBottomButton = "workflow-act-return".equalsIgnoreCase(childBottomButtonId) ? BottomButtonDigiwinAthena.create((UiBotAction)childUiBotAction, (String)bizDataSchema, (Object)bizData, (Map)TaskDataExtractUtil.getSignoffProgressData((UiBotPageData)pcUiBotModel.getPageData()), (Action)childBottomButtonAction, (Integer)childBottomButtonJsonObj.getInteger("iconData"), (String)childBottomButtonId, (String)appCode) : BottomButtonDigiwinAthena.create((UiBotAction)childUiBotAction, (String)bizDataSchema, (Object)bizData, null, (Action)childBottomButtonAction, (Integer)childBottomButtonJsonObj.getInteger("iconData"), (String)childBottomButtonId, (String)appCode);
                ModuleUtils.addRefreshPageId((BottomButtonDigiwinAthena)childBottomButton, (String)apiRequest.getPageId());
                bottomButton.addChildBottomButton(childBottomButton);
            }
            int isHaveChildren = bottomButton.getChildren().size();
            if (null != childrenBottomButtonArray) {
                if (isHaveChildren == 0) {
                    continue;
                }
            } else {
                ModuleUtils.addRefreshPageId((BottomButtonDigiwinAthena)bottomButton, (String)apiRequest.getPageId());
            }
            result.add((Object)bottomButton);
        }
        return result;
    }

    public BottomButtonList buildManualTaskButton(String schema, ApiRequest apiRequest, PageSetting pageSetting, UiBotModel pcUiBotModel, Object[] args) {
        String locale = apiRequest.getLocale();
        List uiBotActions = pcUiBotModel.getActions();
        if (null == uiBotActions || uiBotActions.isEmpty()) {
            return BottomButtonList.createEmpty();
        }
        String bizDataSchema = "";
        UiBotTargetLayoutSearchResult layoutSearchResult = pcUiBotModel.searchPcTargetLayout();
        if (!layoutSearchResult.found()) {
            return BottomButtonList.createEmpty();
        }
        bizDataSchema = layoutSearchResult.getTargetUiBotLayout().getSchema();
        Object bizData = pcUiBotModel.getPageData().get((Object)bizDataSchema);
        if (bizData == null) {
            return BottomButtonList.createEmpty();
        }
        if (bizData instanceof List && ((List)bizData).isEmpty()) {
            return BottomButtonList.createEmpty();
        }
        if (bizData instanceof Map && ((Map)bizData).isEmpty()) {
            return BottomButtonList.createEmpty();
        }
        BottomButtonList result = new BottomButtonList();
        HashMap<String, UiBotAction> allActionMap = new HashMap<String, UiBotAction>();
        for (UiBotAction uiBotAction : uiBotActions) {
            String serviceIdName = uiBotAction.getActionServiceIdName();
            if ("workflow-act-submit".equalsIgnoreCase(serviceIdName)) {
                allActionMap.put("workflow-act-submit", uiBotAction);
                continue;
            }
            if ("basic-data-update".equalsIgnoreCase(uiBotAction.getActionType())) {
                allActionMap.put("basic-data-update", uiBotAction);
                continue;
            }
            String targetServiceIdName = uiBotAction.getUsefulActionServiceIdName();
            if (!"workflow-act-submit".equalsIgnoreCase(targetServiceIdName)) continue;
            allActionMap.put("workflow-act-submit", uiBotAction);
        }
        UiBotModel pageSettingModel = pageSetting.getPageModel();
        String bottomButtonDataSchema = schema;
        UiBotPageData pageData = pageSettingModel.getPageData();
        JSONArray bottomButtonDataArray = (JSONArray)JSON.toJSON(pageData.get(bottomButtonDataSchema));
        String appCode = null;
        for (int i = 0; i < bottomButtonDataArray.size(); ++i) {
            JSONObject bottomButtonJsonObj = bottomButtonDataArray.getJSONObject(i);
            String id = bottomButtonJsonObj.getString("id");
            UiBotAction pcUiBotAction = (UiBotAction)allActionMap.get(id);
            if (null == pcUiBotAction) continue;
            BottomButtonDigiwinAthena bottomButton = BottomButtonDigiwinAthena.create((UiBotAction)pcUiBotAction, (String)bizDataSchema, (Object)bizData, null, (Action)new Action(ActionTypeEnum.CALL_API.getValue()), null, (String)id, appCode);
            ModuleUtils.addRefreshPageId((BottomButtonDigiwinAthena)bottomButton, (String)apiRequest.getPageId());
            result.add((Object)bottomButton);
        }
        return result;
    }

    public UiBotModel buildUibotModel(ApiRequest apiRequest, PageSetting pageSetting, UiBotModel pcUiBotModel, Object ... args) {
        TaskDetail taskDetail = this.build(apiRequest, pageSetting, pcUiBotModel, args);
        UiBotModel uiBotModel = this.uiBotModelBuildService.buildModel(pageSetting, (Object)taskDetail, Boolean.valueOf(true));
        uiBotModel.setBeforeAction(this.buildBeforeAction(apiRequest.getLocale()));
        return uiBotModel;
    }

    private Action<Map<String, Object>> buildBeforeAction(String locale) {
        Action action = new Action();
        action.setType(ActionTypeEnum.POP_PROMPT.getValue());
        PopPromptMsg popPromptMsg = new PopPromptMsg();
        popPromptMsg.setTitle(this.localeService.getLanguageValue(locale, "\u63d0\u793a"));
        popPromptMsg.setContent(this.localeService.getLanguageValue(locale, "\u6b64\u4f5c\u4e1a\u672a\u914d\u7f6e\u79fb\u52a8\u7aef\u754c\u9762\uff0c\u6682\u4e0d\u652f\u6301\u63d0\u4ea4\u64cd\u4f5c\n\u8bf7\u524d\u5f80Web\u7aef\u67e5\u9605\u5904\u7406"));
        Button button = new Button();
        button.setName(this.localeService.getLanguageValue(locale, "\u786e\u5b9a"));
        button.setType(BottomButtonStyleEnum.STRESS.getValue());
        button.setAction(new Action(ActionTypeEnum.BACK.getValue()));
        popPromptMsg.setButtonList(Collections.singletonList(button));
        action.setPopPromptMsg(popPromptMsg);
        return action;
    }
}

