/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.task.strategy;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.core.UiBotModelBuildService;
import com.digiwin.mobile.mobileuibot.core.columntag.ColumnTagService;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonBizApprovalBuilder;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonList;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.core.rule.RuleService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogDetail;
import com.digiwin.mobile.mobileuibot.proxy.uibot.PcUiBotPageDataUtil;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotTargetLayoutSearchResult;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableColumn;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableColumnDefinition;
import com.digiwin.mobile.mobileuibot.task.model.TaskDetail;
import com.digiwin.mobile.mobileuibot.task.model.TaskDetailItemDetail;
import com.digiwin.mobile.mobileuibot.task.strategy.TaskDetailBuildStrategy;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component(value="taskDetailBuildDetailItemDetailStrategy")
public class TaskDetailBuildDetailItemDetailStrategy
implements TaskDetailBuildStrategy {
    private static final Logger logger = LoggerFactory.getLogger(TaskDetailBuildDetailItemDetailStrategy.class);
    @Autowired
    private BottomButtonBizApprovalBuilder bottomButtonBizApprovalBuilder;
    @Autowired
    private RuleService ruleService;
    @Autowired
    private ColumnTagService columnTagService;
    private Boolean hasEditableColumn = false;
    @Autowired
    private UiBotModelBuildService uiBotModelBuildService;

    public String getTaskDetailType() {
        return PageSettingIdPresetEnum.MOBILE_ATHENA_DETAIL_ITEM_DETAIL.toString();
    }

    public UiBotModel buildUibotModel(ApiRequest apiRequest, PageSetting pageSetting, UiBotModel pcUiBotModel, Object ... args) {
        TaskDetail taskDetail = this.build(apiRequest, pageSetting, pcUiBotModel, args);
        return this.uiBotModelBuildService.buildModel(pageSetting, (Object)taskDetail, Boolean.valueOf(true));
    }

    public TaskDetail build(ApiRequest apiRequest, PageSetting pageSetting, UiBotModel pcUiBotModel, Object ... args) {
        TaskDetailItemDetail taskDetailItemDetail = new TaskDetailItemDetail();
        UiBotModel pageSettingModel = pageSetting.getPageModel();
        int dynamicComponentPlaceholderIndex = 0;
        for (int i = 0; i < pageSettingModel.getLayout().size(); ++i) {
            UiBotLayout pageSettingLayout = (UiBotLayout)pageSettingModel.getLayout().get(i);
            if ("${COMPONENT_TYPE}".equalsIgnoreCase(pageSettingLayout.getType())) {
                dynamicComponentPlaceholderIndex = i;
                this.processDynamicComponents(apiRequest, pcUiBotModel, pageSettingLayout, taskDetailItemDetail, args);
                continue;
            }
            this.processFixedComponents(apiRequest, pageSetting, pcUiBotModel, pageSettingLayout, taskDetailItemDetail, args);
        }
        pageSettingModel.getLayout().addAll(dynamicComponentPlaceholderIndex, taskDetailItemDetail.getActualLayoutList());
        pageSettingModel.getLayout().remove(dynamicComponentPlaceholderIndex + taskDetailItemDetail.getActualLayoutList().size());
        return taskDetailItemDetail;
    }

    private void processDynamicComponents(ApiRequest apiRequest, UiBotModel pcUiBotModel, UiBotLayout pageSettingModel, TaskDetailItemDetail taskDetailItemDetail, Object ... args) {
        String locale = apiRequest.getLocale();
        UiBotTargetLayoutSearchResult layoutSearchResult = pcUiBotModel.searchPcTargetLayout();
        if (!layoutSearchResult.found()) {
            return;
        }
        UiBotLayout pcDataLayout = layoutSearchResult.getTargetUiBotLayout();
        if (pcDataLayout.isTypeOfTable()) {
            this.processDynamicComponentsWithPcTable(apiRequest, pcUiBotModel, taskDetailItemDetail, locale, pcDataLayout, args);
        } else if (pcDataLayout.isTypeOfFormList()) {
            this.processDynamicComponentsWithPcFormList(apiRequest, pcUiBotModel, taskDetailItemDetail, locale, pcDataLayout, args);
        } else {
            return;
        }
    }

    private void processDynamicComponentsWithPcTable(ApiRequest apiRequest, UiBotModel pcUiBotModel, TaskDetailItemDetail taskDetailItemDetail, String locale, UiBotLayout pcDataLayout, Object ... args) {
        String schema = pcDataLayout.getSchema();
        List bizDataList = (List)pcUiBotModel.getPageData().get((Object)schema);
        Assert.notNull((Object)bizDataList, (String)("pagedata." + schema + " cannot be null"));
        List tableColumnDefinitionList = pcDataLayout.getColumnDefs();
        if (tableColumnDefinitionList == null) {
            return;
        }
        List scriptFilterList = pcDataLayout.getScriptFilters();
        List tableColumns = UiBotTableColumnDefinition.decomposeTableColumnDefinitions((List)tableColumnDefinitionList);
        List mobileRuleList = this.ruleService.findByRulePath(schema);
        List columnTagList = this.columnTagService.listColumnTagsByPath(schema);
        this.hasEditableColumn = tableColumns.stream().anyMatch(UiBotTableColumn::canEdit);
        for (Map bizData : bizDataList) {
            String dataKey = PcUiBotPageDataUtil.getBizDataKey((UiBotModel)pcUiBotModel, (String)schema, (Map)bizData);
            if (!dataKey.equalsIgnoreCase(apiRequest.getExtraParameter().getDataKey())) continue;
            taskDetailItemDetail.addMobileComponentsByColumnAndBizData(locale, tableColumns, pcUiBotModel, bizData, (DigiwinAtmcBacklogDetail)args[0], mobileRuleList, columnTagList, apiRequest);
            break;
        }
    }

    private void processDynamicComponentsWithPcFormList(ApiRequest apiRequest, UiBotModel pcUiBotModel, TaskDetailItemDetail taskDetailItemDetail, String locale, UiBotLayout pcDataLayout, Object ... args) {
        String schema = pcDataLayout.getSchema();
        Map bizData = (Map)pcUiBotModel.getPageData().get((Object)schema);
        Assert.notNull((Object)bizData, (String)("pagedata." + schema + " cannot be null"));
        List pcFieldLayoutList = pcDataLayout.decomposeFieldsWithPcFormList(null);
        List tableColumns = pcFieldLayoutList.stream().map(UiBotLayout::parseToTableColumn).collect(Collectors.toList());
        List mobileRuleList = this.ruleService.findByRulePath(schema);
        List columnTagList = this.columnTagService.listColumnTagsByPath(schema);
        this.hasEditableColumn = tableColumns.stream().anyMatch(UiBotTableColumn::canEdit);
        String dataKey = PcUiBotPageDataUtil.getBizDataKey((UiBotModel)pcUiBotModel, (String)schema, (Map)bizData);
        if (dataKey.equalsIgnoreCase(apiRequest.getExtraParameter().getDataKey())) {
            taskDetailItemDetail.addMobileComponentsByColumnAndBizData(locale, tableColumns, pcUiBotModel, bizData, (DigiwinAtmcBacklogDetail)args[0], mobileRuleList, columnTagList, apiRequest);
        }
    }

    private void processFixedComponents(ApiRequest apiRequest, PageSetting pageSetting, UiBotModel pcUiBotModel, UiBotLayout layout, TaskDetailItemDetail taskDetailItemDetail, Object ... args) {
        String locale = apiRequest.getLocale();
        if (layout.getType().equalsIgnoreCase(this.bottomButtonBizApprovalBuilder.getMobileComponentType())) {
            BottomButtonList bottomButtonList = new BottomButtonList();
            bottomButtonList.add((Object)BottomButtonDigiwinAthena.createNormalCancelButton((String)locale));
            if (this.hasEditableColumn.booleanValue()) {
                bottomButtonList.add((Object)BottomButtonDigiwinAthena.createStressDoneButton((String)locale));
            }
            taskDetailItemDetail.put((Object)layout.getSchema(), (Object)bottomButtonList);
        }
    }
}

