/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.task.strategy.custom;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.map.MapUtil;
import com.digiwin.mobile.mobileuibot.core.UiBotModelBuildService;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.basic.BlankArea;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonList;
import com.digiwin.mobile.mobileuibot.core.component.card.card.Card;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtab.CustomTabs;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtab.CustomTabsComponentBuilder;
import com.digiwin.mobile.mobileuibot.core.component.title.titlebody.BaseTitleBodyBuilder;
import com.digiwin.mobile.mobileuibot.core.component.title.titlebody.TitleBody;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.util.ModuleUtils;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.task.model.TaskDetail;
import com.digiwin.mobile.mobileuibot.task.model.TaskDetailBizReport;
import com.digiwin.mobile.mobileuibot.task.strategy.TaskDetailBuildStrategy;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="taskDetailBuildApcSupportHourReportListStrategy")
public class TaskDetailBuildApcSupportHourReportListStrategy
implements TaskDetailBuildStrategy {
    private static final Logger log = LoggerFactory.getLogger(TaskDetailBuildApcSupportHourReportListStrategy.class);
    @Autowired
    private BaseTitleBodyBuilder baseTitleBodyBuilder;
    @Autowired
    private CustomTabsComponentBuilder tabsComponentBuilder;
    @Autowired
    private LocaleService localeService;
    @Autowired
    private UiBotModelBuildService uiBotModelBuildService;

    public String getTaskDetailType() {
        return "workshop_plan_syn_userproject_apc_hour_support";
    }

    public TaskDetail build(ApiRequest apiRequest, PageSetting pageSetting, UiBotModel pcUiBotModel, Object ... args) {
        TaskDetailBizReport taskDetailBizReport = new TaskDetailBizReport(this.localeService);
        UiBotModel uiBotModel = pageSetting.getPageModel();
        List uiBotLayouts = uiBotModel.getLayout();
        UiBotPageData uiBotPageData = pageSetting.getPageModel().getPageData();
        Boolean grayButton = true;
        for (UiBotLayout layout : uiBotLayouts) {
            switch (layout.getType()) {
                case "TITLE_BODY": {
                    taskDetailBizReport.put((Object)layout.getSchema(), (Object)this.baseTitleBodyBuilder.build(apiRequest, pageSetting, pcUiBotModel, TitleBody.class, args));
                    break;
                }
                case "CARD": {
                    Card card = (Card)JsonUtil.objectToJavaObject((Object)uiBotPageData.get((Object)layout.getSchema()), Card.class);
                    Card.handle((ApiRequest)apiRequest, (UiBotModel)pcUiBotModel, (Card)card);
                    taskDetailBizReport.put((Object)layout.getSchema(), (Object)card);
                    break;
                }
                case "BLANK_AREA": {
                    taskDetailBizReport.put((Object)layout.getSchema(), JsonUtil.objectToJavaObject((Object)uiBotPageData.get((Object)layout.getSchema()), BlankArea.class));
                    break;
                }
                case "CUSTOM_TABS": {
                    CustomTabs tabItems = this.tabsComponentBuilder.build(apiRequest, pageSetting, pcUiBotModel, CustomTabs.class, args);
                    taskDetailBizReport.put((Object)layout.getSchema(), (Object)tabItems);
                    grayButton = tabItems.getGrayButton();
                    break;
                }
                case "BOTTOM_BUTTON": {
                    List buttons = ModuleUtils.listMapToListObject((List)((List)uiBotModel.getPageData().get((Object)layout.getSchema())), BottomButtonDigiwinAthena.class);
                    Optional<UiBotLayout> optional = pcUiBotModel.getLayout().stream().filter(pcLayout -> "apc_hour_support-task-detail-waitting".equals(pcLayout.getType())).findFirst();
                    List actions = Collections.emptyList();
                    if (optional.isPresent()) {
                        actions = optional.get().getActions();
                    }
                    for (BottomButtonDigiwinAthena bottomButton : buttons) {
                        Action action2;
                        Optional<UiBotAction> defaultOption;
                        bottomButton.setName(this.localeService.getLanguageValue(apiRequest.getLocale(), bottomButton.getName()));
                        if (grayButton.booleanValue()) {
                            bottomButton.setEnable(Boolean.valueOf(false));
                        }
                        UiBotAction rawDataAction = null;
                        if (!CollectionUtils.isEmpty((Collection)actions) && (defaultOption = actions.stream().filter(action -> "submit-close-task".equals(action.getId())).findFirst()).isPresent()) {
                            rawDataAction = defaultOption.get();
                        }
                        if ((action2 = bottomButton.getAction()) == null) {
                            action2 = new Action();
                        }
                        HashMap<String, Object> rawData = new HashMap<String, Object>(3);
                        if (rawDataAction != null && rawDataAction.getSubmitType() != null) {
                            List woOpReportDataList = (List)MapUtil.getOrDefault((Map)pcUiBotModel.getPageData(), (String)rawDataAction.getSubmitType().getSchema(), Collections.emptyList());
                            if (!CollectionUtils.isEmpty((Collection)woOpReportDataList)) {
                                woOpReportDataList.forEach(e -> e.put("isCloseTask", true));
                            }
                            rawData.put("data", woOpReportDataList);
                            rawDataAction.remove((Object)"checkCompleteAction");
                        }
                        rawData.put("action", rawDataAction);
                        rawData.put("isAPC", true);
                        rawData.put("pageId", apiRequest.getPageId());
                        action2.setRawData(rawData);
                        bottomButton.setAction(action2);
                    }
                    taskDetailBizReport.put((Object)layout.getSchema(), JsonUtil.objectToJavaObject((Object)buttons, BottomButtonList.class));
                    break;
                }
            }
        }
        return taskDetailBizReport;
    }

    public UiBotModel buildUibotModel(ApiRequest apiRequest, PageSetting pageSetting, UiBotModel pcUiBotModel, Object ... args) {
        if (ObjectUtils.isNotEmpty((Object)pcUiBotModel.getFinished()) && pcUiBotModel.getFinished().booleanValue()) {
            return UiBotModel.workReminderEmptyImageUibotModel((String)apiRequest.getLocale());
        }
        TaskDetail taskDetail = this.build(apiRequest, pageSetting, pcUiBotModel, args);
        return this.uiBotModelBuildService.buildModel(pageSetting, (Object)taskDetail, Boolean.valueOf(true));
    }
}

