/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.task.strategy.custom;

import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonList;
import com.digiwin.mobile.mobileuibot.core.component.input.calendar.InputCalendar;
import com.digiwin.mobile.mobileuibot.core.component.input.calendar.InputCalendarDate;
import com.digiwin.mobile.mobileuibot.core.component.input.calendar.InputCalendarTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.numeric.InputNumeric;
import com.digiwin.mobile.mobileuibot.core.component.input.numeric.InputNumericTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.windowselect.single.InputWindowSingleSelect;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.util.ModuleUtils;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.rule.relation.RelationRule;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.service.DigiwinAtmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.esp.service.DigiwinEspProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.service.DigiwinPcUiBotProxyService;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StopWatch;
import org.springframework.util.StringUtils;

@Component(value="uiBotModelBuildApcSupportBottomStrategy")
public class UiBotModelBuildApcSupportBottomStrategy
implements UiBotModelBuildStrategy {
    private static final Logger logger = LoggerFactory.getLogger(UiBotModelBuildApcSupportBottomStrategy.class);
    @Autowired
    private DigiwinEspProxyService digiwinEspProxyService;
    @Autowired
    private DigiwinAtmcProxyService digiwinAtmcProxyService;
    @Autowired
    private DigiwinPcUiBotProxyService digiwinPcUiBotProxyService;
    @Autowired
    private LocaleService localeService;

    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        StopWatch stopWatch = new StopWatch("Build Apc support bottom");
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel = useMockData == false && modelTypeShow == false ? this.doActually(pageSetting, apiRequest, stopWatch) : this.doMockData(pageSetting, apiRequest);
        logger.debug(stopWatch.prettyPrint());
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest, StopWatch stopWatch) {
        UiBotModel uiBotModel = pageSetting.getPageModel();
        List uiBotLayouts = uiBotModel.getLayout();
        UiBotPageData pageData = uiBotModel.getPageData();
        String locale = apiRequest.getLocale();
        ApiRawData rawData = apiRequest.getRawData();
        for (UiBotLayout layout : uiBotLayouts) {
            String schema = layout.getSchema();
            switch (layout.getType()) {
                case "WINDOW_SINGLE_SELECT": {
                    rawData.put("isAPC", true);
                    rawData.put("type", layout.getSchema());
                    pageData.put((Object)layout.getSchema(), (Object)InputWindowSingleSelect.create((String)this.localeService.getLanguageValue(locale, layout.getLabel()), (String)layout.getSchema(), (String)(AppContext.getBaseUrl() + "/mobile/v1/proxy/window/data/list"), (String)locale, (Map)rawData, (String)"", (String)"", (RelationRule)new RelationRule(), Collections.emptyMap()));
                    break;
                }
                case "INPUT_NUMERIC": {
                    pageData.put((Object)layout.getSchema(), (Object)InputNumeric.create((Integer)999, (Integer)0, (String)"0", (String)this.localeService.getLanguageValue(locale, layout.getLabel()), (Integer)InputNumericTypeEnum.INTEGER.getValue()));
                    break;
                }
                case "INPUT_CALENDAR": {
                    pageData.put((Object)layout.getSchema(), (Object)InputCalendar.create((String)this.localeService.getLanguageValue(locale, layout.getLabel()), (Integer)InputCalendarTypeEnum.SELECT_DATE_RANGE.getValue(), (InputCalendarDate)InputCalendarDate.createToday(), (InputCalendarDate)InputCalendarDate.create((String)"9999", (String)"12", (String)"31"), (Boolean)true, (Boolean)false, (Boolean)true, (String)this.localeService.getLanguageValue(locale, "\u8bf7\u9009\u62e9\u65e5\u671f\u533a\u95f4")));
                    break;
                }
                case "BOTTOM_BUTTON": {
                    BottomButtonList bottomButtonList = (BottomButtonList)JsonUtil.objectToJavaObject((Object)pageSetting.getPageModel().getPageData().get((Object)layout.getSchema()), BottomButtonList.class);
                    HashMap buttonRawData = new HashMap(6);
                    bottomButtonList.forEach(arg_0 -> this.lambda$doActually$0(apiRequest, locale, buttonRawData, (Map)rawData, arg_0));
                    pageData.put((Object)schema, (Object)bottomButtonList);
                    break;
                }
            }
        }
        return uiBotModel;
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return null;
    }

    private /* synthetic */ void lambda$doActually$0(ApiRequest apiRequest, String locale, Map buttonRawData, Map rawData, BottomButtonDigiwinAthena bottomButtonDigiwinAthena) {
        Action action;
        String jumpPageTitle;
        String buttonName = bottomButtonDigiwinAthena.getName();
        if (StringUtils.hasLength((String)buttonName)) {
            bottomButtonDigiwinAthena.setName(this.localeService.getLanguageValue(apiRequest.getLocale(), buttonName));
        }
        if (StringUtils.hasLength((String)(jumpPageTitle = (action = bottomButtonDigiwinAthena.getAction()).getJumpPageTitle()))) {
            action.setJumpPageTitle(this.localeService.getLanguageValue(locale, jumpPageTitle));
        }
        buttonRawData.put("data", rawData.get("datas"));
        buttonRawData.put("action", rawData.get("action"));
        buttonRawData.put("pageId", apiRequest.getPageId());
        action.setRawData((Object)buttonRawData);
        ModuleUtils.addRefreshPageId((BottomButtonDigiwinAthena)bottomButtonDigiwinAthena, (String)apiRequest.getRefreshPageId());
    }
}

