/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.user.service.impl;

import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.crypto.aes.AESUtil;
import com.digiwin.mobile.mobileuibot.common.crypto.digest.DigestUtil;
import com.digiwin.mobile.mobileuibot.common.exception.ServiceException;
import com.digiwin.mobile.mobileuibot.common.string.StringUtil;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.emc.model.CheckVerificationCodeResponse;
import com.digiwin.mobile.mobileuibot.proxy.emc.service.DigiwinEmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.iam.model.DigiwinIamAccountRegisterResponse;
import com.digiwin.mobile.mobileuibot.proxy.iam.model.DigiwinIamUserInfo;
import com.digiwin.mobile.mobileuibot.proxy.iam.service.DigiwinIamProxyService;
import com.digiwin.mobile.mobileuibot.user.enums.VerificationTypeEnum;
import com.digiwin.mobile.mobileuibot.user.request.AccountExistCheckReq;
import com.digiwin.mobile.mobileuibot.user.request.CheckVerificationCodeReq;
import com.digiwin.mobile.mobileuibot.user.request.DoubleCheckUpdateReq;
import com.digiwin.mobile.mobileuibot.user.request.PasswordUpdateReq;
import com.digiwin.mobile.mobileuibot.user.request.VerificationCodeReq;
import com.digiwin.mobile.mobileuibot.user.service.UserService;
import java.util.HashMap;
import java.util.Optional;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UserServiceImpl
implements UserService {
    private static final Logger log = LoggerFactory.getLogger(UserServiceImpl.class);
    @Autowired
    private DigiwinIamProxyService digiwinIamProxyService;
    @Autowired
    private DigiwinEmcProxyService digiwinEmcProxyService;
    @Autowired
    private LocaleService localeService;

    public void doubleCheckUpdate(DoubleCheckUpdateReq request, DigiwinIamUserInfo user) {
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        params.put("id", user.getId());
        params.put("name", user.getName());
        if (BooleanUtils.isTrue((Boolean)request.getDoubleCheck())) {
            params.put("doubleCheck", true);
            params.put("identityCodeAcceptType", request.getIdentityCodeAcceptType());
        } else {
            params.put("doubleCheck", false);
        }
        this.digiwinIamProxyService.doubleCheckUpdate(request.getIamUserToken(), params);
    }

    public DigiwinIamAccountRegisterResponse accountExistCheck(AccountExistCheckReq request) {
        if (VerificationTypeEnum.EMAIL.getValue().equals(request.getType())) {
            return this.digiwinIamProxyService.emailExistCheck(request.getIamUserToken(), request.getAccount());
        }
        if (VerificationTypeEnum.MOBILEPHONE.getValue().equals(request.getType())) {
            return this.digiwinIamProxyService.mobilephoneExistCheck(request.getIamUserToken(), request.getAccount());
        }
        return new DigiwinIamAccountRegisterResponse();
    }

    public void verificationCode(VerificationCodeReq request) {
        this.digiwinEmcProxyService.sendVerificationCode(request.getIamUserToken(), request.getType(), request.getAccount(), request.getScene());
    }

    public String checkVerificationCodeAndRenew(CheckVerificationCodeReq request) {
        HashMap<String, String> params = new HashMap<String, String>(3);
        params.put("account", request.getAccount());
        params.put("scene", request.getScene());
        params.put("identifyingCode", request.getIdentifyingCode());
        CheckVerificationCodeResponse response = this.digiwinEmcProxyService.checkVerificationCodeAndRenew(request.getIamUserToken(), params);
        if (response == null || !response.isSuccess()) {
            String result = Optional.ofNullable(response).map(CheckVerificationCodeResponse::getResult).map(s -> s.replace("failed:", "")).orElse("\u9a8c\u8bc1\u7801\u6709\u8bef\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
            throw new ServiceException(this.localeService.getLanguageValue(AppRequestContext.getContextEntity().getLocale(), result));
        }
        return StringUtil.valueOf((Object)response.getCode());
    }

    public void passwordUpdate(PasswordUpdateReq request) {
        String encryptPwd = "";
        try {
            encryptPwd = AESUtil.decrypt((String)AppContext.getApiUrlSetting().getAesKey(), (String)request.getPassword());
        }
        catch (Exception e) {
            encryptPwd = request.getPassword();
        }
        HashMap<String, String> params = new HashMap<String, String>(3);
        params.put("account", request.getAccount());
        params.put("password", DigestUtil.getDigestedStringForDwIamLoginByAes((String)encryptPwd));
        params.put("verificationCode", request.getVerificationCode());
        this.digiwinIamProxyService.passwordUpdate(request.getIamUserToken(), params);
    }
}

