/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.versionManage;

import com.digiwin.mobile.mobileuibot.api.ApiResponse;
import com.digiwin.mobile.mobileuibot.api.PageResult;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.versionManage.VersionManageConditionService;
import com.digiwin.mobile.mobileuibot.versionManage.request.AppConditionAddRequest;
import com.digiwin.mobile.mobileuibot.versionManage.request.AppConditionPageRequest;
import com.digiwin.mobile.mobileuibot.versionManage.request.AppConditionUpdateRequest;
import com.digiwin.mobile.mobileuibot.versionManage.response.AppConditionResponse;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/mobile/v2/version/manage/condition"})
public class VersionManageConditionController {
    private static final Logger log = LoggerFactory.getLogger(VersionManageConditionController.class);
    @Autowired
    private VersionManageConditionService versionManageConditionService;
    @Autowired
    private LocaleService localeService;

    @PostMapping(value={"/list"})
    public ApiResponse<List<AppConditionResponse>> list(@RequestBody AppConditionPageRequest request) {
        return ApiResponse.buildOK((Object)this.versionManageConditionService.list(request));
    }

    @PostMapping(value={"/list/page"})
    public ApiResponse<PageResult<AppConditionResponse>> listPage(@RequestBody AppConditionPageRequest pageRequest) {
        return ApiResponse.buildOK((Object)this.versionManageConditionService.listPage(pageRequest));
    }

    @GetMapping(value={"/select/{id}"})
    public ApiResponse<AppConditionResponse> selectById(@PathVariable(value="id") Long id) {
        if (null == id) {
            return ApiResponse.buildError((String)this.localeService.getLanguageValue("\u67e5\u8be2\u6570\u636e\u4e0d\u5b58\u5728"));
        }
        AppConditionResponse appConditionResponse = this.versionManageConditionService.selectById(id);
        if (null == appConditionResponse) {
            return ApiResponse.buildError((String)this.localeService.getLanguageValue("\u67e5\u8be2\u6570\u636e\u4e0d\u5b58\u5728"));
        }
        return ApiResponse.buildOK((Object)appConditionResponse);
    }

    @PostMapping(value={"/add"})
    public ApiResponse<Boolean> add(@Valid @RequestBody AppConditionAddRequest addRequest) {
        return this.versionManageConditionService.add(addRequest);
    }

    @PostMapping(value={"/update"})
    public ApiResponse<Boolean> update(@Valid @RequestBody AppConditionUpdateRequest updateRequest) {
        return this.versionManageConditionService.update(updateRequest);
    }

    @GetMapping(value={"/delete/{id}"})
    public ApiResponse<Boolean> deleteById(@PathVariable(value="id") Long id) {
        if (null == id) {
            return ApiResponse.buildError((String)this.localeService.getLanguageValue("\u6570\u636e\u4e0d\u5b58\u5728"));
        }
        return this.versionManageConditionService.deleteById(id);
    }
}

