/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.versionManage;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.digiwin.mobile.mobileuibot.api.ApiResponse;
import com.digiwin.mobile.mobileuibot.api.PageResult;
import com.digiwin.mobile.mobileuibot.config.mysql.Db2Transactional;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.model.db2.AppCondition;
import com.digiwin.mobile.mobileuibot.versionManage.VersionManageConditionService;
import com.digiwin.mobile.mobileuibot.versionManage.request.AppConditionAddRequest;
import com.digiwin.mobile.mobileuibot.versionManage.request.AppConditionItemRequest;
import com.digiwin.mobile.mobileuibot.versionManage.request.AppConditionPageRequest;
import com.digiwin.mobile.mobileuibot.versionManage.request.AppConditionUpdateRequest;
import com.digiwin.mobile.mobileuibot.versionManage.response.AppConditionItemResponse;
import com.digiwin.mobile.mobileuibot.versionManage.response.AppConditionResponse;
import com.digiwin.mobile.mobileuibot.versionManage.service.AppConditionItemService;
import com.digiwin.mobile.mobileuibot.versionManage.service.AppConditionService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VersionManageConditionServiceImpl
implements VersionManageConditionService {
    @Autowired
    private AppConditionService appConditionService;
    @Autowired
    private AppConditionItemService appConditionItemService;
    @Autowired
    private LocaleService localeService;

    public List<AppConditionResponse> list(AppConditionPageRequest request) {
        return this.convert(this.appConditionService.list(request));
    }

    private List<AppConditionResponse> convert(List<AppCondition> list) {
        if (CollectionUtils.isEmpty(list)) {
            return new ArrayList<AppConditionResponse>();
        }
        List<AppConditionResponse> conditionResponses = list.stream().map(AppConditionResponse::convert).collect(Collectors.toList());
        Set appConditionIds = conditionResponses.stream().map(AppConditionResponse::getId).collect(Collectors.toSet());
        List appConditionItems = this.appConditionItemService.selectByAppConditionIds(appConditionIds);
        if (CollectionUtils.isNotEmpty((Collection)appConditionItems)) {
            Map<Long, List<AppConditionItemResponse>> itemMap = appConditionItems.stream().map(AppConditionItemResponse::convert).collect(Collectors.groupingBy(AppConditionItemResponse::getAppConditionId));
            conditionResponses.forEach(condition -> {
                List itemResponses = (List)itemMap.get(condition.getId());
                if (CollectionUtils.isNotEmpty((Collection)itemResponses)) {
                    condition.setItem(itemResponses);
                }
            });
        }
        return conditionResponses;
    }

    public PageResult<AppConditionResponse> listPage(AppConditionPageRequest pageRequest) {
        Page page = this.appConditionService.listPage(pageRequest);
        PageResult pageResult = new PageResult();
        pageResult.setData(this.convert(page.getRecords()));
        pageResult.setTotal(Long.valueOf(page.getTotal()));
        pageResult.setPageNum(Long.valueOf(page.getCurrent()));
        pageResult.setPageSize(Long.valueOf(page.getSize()));
        pageResult.setTotalPage(Long.valueOf(page.getPages()));
        return pageResult;
    }

    public AppConditionResponse selectById(Long id) {
        AppCondition appCondition = this.appConditionService.selectById(id);
        if (null == appCondition) {
            return null;
        }
        AppConditionResponse appConditionResponse = AppConditionResponse.convert((AppCondition)appCondition);
        List appConditionItem = this.appConditionItemService.selectByAppConditionId(id);
        if (CollectionUtils.isNotEmpty((Collection)appConditionItem)) {
            appConditionResponse.setItem(appConditionItem.stream().map(AppConditionItemResponse::convert).collect(Collectors.toList()));
        }
        return appConditionResponse;
    }

    @Db2Transactional(rollbackFor={Exception.class})
    public ApiResponse<Boolean> add(AppConditionAddRequest addRequest) {
        ApiResponse checkResult = this.verifyAddOrUpdateParam(addRequest);
        if (checkResult.isError()) {
            return checkResult;
        }
        AppCondition appCondition = this.appConditionService.add(addRequest);
        this.appConditionItemService.add(appCondition.getId(), addRequest.getItem());
        return ApiResponse.buildOK();
    }

    private ApiResponse<Boolean> verifyAddOrUpdateParam(AppConditionAddRequest request) {
        if (CollectionUtils.isNotEmpty((Collection)request.getItem())) {
            for (AppConditionItemRequest item : request.getItem()) {
                if (!item.verifyContentParam()) {
                    return ApiResponse.buildError((String)this.localeService.getLanguageValue("\u6761\u4ef6\u503c\u683c\u5f0f\u9519\u8bef"));
                }
                if (item.verifyVerifyParam()) continue;
                return ApiResponse.buildError((String)this.localeService.getLanguageValue("\u6761\u4ef6\u503c\u6821\u9a8c\u683c\u5f0f\u9519\u8bef"));
            }
        }
        return ApiResponse.buildOK();
    }

    @Db2Transactional(rollbackFor={Exception.class})
    public ApiResponse<Boolean> update(AppConditionUpdateRequest updateRequest) {
        AppCondition appCondition = this.appConditionService.selectById(updateRequest.getId());
        if (null == appCondition) {
            return ApiResponse.buildError((String)this.localeService.getLanguageValue("\u6570\u636e\u4e0d\u5b58\u5728"));
        }
        ApiResponse checkResult = this.verifyAddOrUpdateParam((AppConditionAddRequest)updateRequest);
        if (checkResult.isError()) {
            return checkResult;
        }
        this.appConditionService.update(appCondition, updateRequest);
        this.appConditionItemService.update(appCondition.getId(), updateRequest.getItem());
        return ApiResponse.buildOK();
    }

    @Db2Transactional(rollbackFor={Exception.class})
    public ApiResponse<Boolean> deleteById(Long id) {
        AppCondition appCondition = this.appConditionService.selectById(id);
        if (null == appCondition) {
            return ApiResponse.buildError((String)this.localeService.getLanguageValue("\u6570\u636e\u4e0d\u5b58\u5728"));
        }
        this.appConditionService.deleteById(id);
        this.appConditionItemService.deleteByAppConditionId(id);
        return ApiResponse.buildOK();
    }
}

