/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.versionManage;

import com.digiwin.mobile.mobileuibot.api.ApiResponse;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.versionManage.VersionUpgradeService;
import com.digiwin.mobile.mobileuibot.versionManage.request.AppUpgradeReq;
import com.digiwin.mobile.mobileuibot.versionManage.response.AppCheckResp;
import com.digiwin.mobile.mobileuibot.versionManage.response.AppUpgradeResp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/mobile/v2/version"})
public class VersionUpgradeController {
    private static final Logger log = LoggerFactory.getLogger(VersionUpgradeController.class);
    @Autowired
    private VersionUpgradeService versionUpgradeService;

    @PostMapping(value={"/upgrade"})
    public ApiResponse<AppUpgradeResp> upgrade(@RequestBody AppUpgradeReq vo) {
        log.info("\u7248\u66f4\u63a5\u53e3\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JsonUtil.javaObjectToJsonString((Object)vo));
        return ApiResponse.buildOK((Object)this.versionUpgradeService.upgrade(vo));
    }

    @GetMapping(value={"/check-update"})
    public ApiResponse<AppCheckResp> checkUpdate(@RequestParam(name="appId") String appId, @RequestParam(name="version") String version, @RequestParam(name="arch") String arch, @RequestParam(name="brand") String brand, @RequestParam(name="locale") String locale) {
        log.info("\u68c0\u67e5\u66f4\u65b0\u63a5\u53e3\u8bf7\u6c42\u53c2\u6570\uff1aappId:{}, version:{}, brand:{}, arch:{}, locale:{}", new Object[]{appId, version, brand, arch, locale});
        AppUpgradeReq vo = new AppUpgradeReq().setAppId(appId).setVersion(version).setArch(arch).setBrand(brand).setLocale(locale);
        return ApiResponse.buildOK((Object)this.versionUpgradeService.checkUpdate(vo));
    }
}

