/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.versionManage.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.digiwin.mobile.mobileuibot.dto.AppClientPageDto;
import com.digiwin.mobile.mobileuibot.dto.AppClientVo;
import com.digiwin.mobile.mobileuibot.mapper.db2.AppClientMapper;
import com.digiwin.mobile.mobileuibot.mock.enums.DelFlagEnum;
import com.digiwin.mobile.mobileuibot.model.db2.AppClient;
import com.digiwin.mobile.mobileuibot.versionManage.enums.PublishEnum;
import com.digiwin.mobile.mobileuibot.versionManage.enums.ValidEnum;
import com.digiwin.mobile.mobileuibot.versionManage.request.AppClientAddRequest;
import com.digiwin.mobile.mobileuibot.versionManage.request.AppClientUpdateRequest;
import com.digiwin.mobile.mobileuibot.versionManage.service.AppClientService;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AppClientServiceImpl
implements AppClientService {
    @Autowired
    private AppClientMapper appClientMapper;

    public AppClient getPublishByAppId(Long appId) {
        if (appId == null) {
            return null;
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(AppClient::getAppId, (Object)appId);
        wrapper.eq(AppClient::getDelFlag, (Object)DelFlagEnum.UNDELETE.getValue());
        wrapper.eq(AppClient::getPublish, (Object)PublishEnum.PUBLISH.getValue());
        return (AppClient)this.appClientMapper.selectOne((Wrapper)wrapper, false);
    }

    public AppClient getValidByAppIdAndVersion(Long appId, String version) {
        if (appId == null || StringUtils.isBlank((CharSequence)version)) {
            return null;
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(AppClient::getAppId, (Object)appId);
        wrapper.eq(AppClient::getDelFlag, (Object)DelFlagEnum.UNDELETE.getValue());
        wrapper.eq(AppClient::getVersion, (Object)version);
        wrapper.eq(AppClient::getValid, (Object)ValidEnum.VALID.getValue());
        return (AppClient)this.appClientMapper.selectOne((Wrapper)wrapper, false);
    }

    public List<AppClient> getValidMiddleVersion(Long appId, Integer latestSequence, Integer sequence) {
        if (appId == null || latestSequence == null || sequence == null) {
            return Collections.emptyList();
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(AppClient::getAppId, (Object)appId);
        wrapper.eq(AppClient::getDelFlag, (Object)DelFlagEnum.UNDELETE.getValue());
        wrapper.eq(AppClient::getValid, (Object)ValidEnum.VALID.getValue());
        ((LambdaQueryWrapper)wrapper.gt(AppClient::getSequence, (Object)sequence)).le(AppClient::getSequence, (Object)latestSequence);
        wrapper.orderByDesc(AppClient::getSequence);
        return this.appClientMapper.selectList((Wrapper)wrapper);
    }

    public Page<AppClientVo> listPage(AppClientPageDto pageRequest) {
        if (pageRequest == null) {
            return new Page();
        }
        Page page = new Page((long)pageRequest.getPageNum().intValue(), (long)pageRequest.getPageSize().intValue());
        return this.appClientMapper.listPage(page, pageRequest);
    }

    public AppClientVo queryById(Long id) {
        if (id == null) {
            return null;
        }
        return this.appClientMapper.queryById(id);
    }

    public AppClient selectById(Long id) {
        if (id == null) {
            return null;
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(AppClient::getId, (Object)id);
        wrapper.eq(AppClient::getDelFlag, (Object)DelFlagEnum.UNDELETE.getValue());
        return (AppClient)this.appClientMapper.selectOne((Wrapper)wrapper, false);
    }

    public AppClient add(AppClientAddRequest addRequest) {
        if (addRequest == null) {
            return null;
        }
        AppClient appClient = new AppClient().setId(null).setAppId(addRequest.getAppId()).setVersion(addRequest.getVersion()).setSequence(this.getLatestSequence(addRequest.getAppId(), addRequest.getVersion())).setDescr(addRequest.getDescr()).setMethods(addRequest.getMethods()).setUrl32(addRequest.getUrl32()).setUrl64(addRequest.getUrl64()).setMd532(addRequest.getMd532()).setMd564(addRequest.getMd564()).setBrand(addRequest.convertBrand()).setTipsTitle(addRequest.getTipsTitle()).setTips(addRequest.getTips()).setLang(addRequest.convertLang()).setValid(ValidEnum.INVALID.getValue()).setPublish(PublishEnum.UNPUBLISH.getValue()).setDelFlag(DelFlagEnum.UNDELETE.getValue());
        this.appClientMapper.insert((Object)appClient);
        return appClient;
    }

    private Integer getLatestSequence(Long appId, String version) {
        if (appId == null || StringUtils.isBlank((CharSequence)version)) {
            throw new IllegalArgumentException("appId or version is null or empty");
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(AppClient::getAppId, (Object)appId);
        wrapper.eq(AppClient::getVersion, (Object)version);
        AppClient appClient = (AppClient)this.appClientMapper.selectOne((Wrapper)wrapper, false);
        if (appClient != null) {
            return appClient.getSequence();
        }
        LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
        wrapper2.eq(AppClient::getAppId, (Object)appId);
        wrapper2.orderByDesc(AppClient::getSequence);
        AppClient appClient2 = (AppClient)this.appClientMapper.selectOne((Wrapper)wrapper2, false);
        return appClient2 == null ? 1 : appClient2.getSequence() + 1;
    }

    public void update(AppClient appClient, AppClientUpdateRequest updateRequest) {
        if (appClient == null || updateRequest == null) {
            return;
        }
        appClient.setDescr(updateRequest.getDescr()).setMethods(updateRequest.getMethods()).setUrl32(updateRequest.getUrl32()).setUrl64(updateRequest.getUrl64()).setMd532(updateRequest.getMd532()).setMd564(updateRequest.getMd564()).setBrand(updateRequest.convertBrand()).setTipsTitle(updateRequest.getTipsTitle()).setTips(updateRequest.getTips()).setLang(updateRequest.convertLang()).clearTime();
        this.appClientMapper.updateById((Object)appClient);
    }

    public void release(AppClient appClient, AppClientUpdateRequest releaseRequest) {
        if (appClient == null || releaseRequest == null) {
            return;
        }
        appClient.setDescr(releaseRequest.getDescr()).setMethods(releaseRequest.getMethods()).setUrl32(releaseRequest.getUrl32()).setUrl64(releaseRequest.getUrl64()).setMd532(releaseRequest.getMd532()).setMd564(releaseRequest.getMd564()).setBrand(releaseRequest.convertBrand()).setTipsTitle(releaseRequest.getTipsTitle()).setTips(releaseRequest.getTips()).setLang(releaseRequest.convertLang()).setValid(ValidEnum.VALID.getValue()).setPublish(PublishEnum.PUBLISH.getValue()).setDelFlag(DelFlagEnum.UNDELETE.getValue()).clearTime();
        this.appClientMapper.updateById((Object)appClient);
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        wrapper.eq(AppClient::getAppId, (Object)appClient.getAppId());
        wrapper.eq(AppClient::getDelFlag, (Object)DelFlagEnum.UNDELETE.getValue());
        wrapper.eq(AppClient::getPublish, (Object)PublishEnum.PUBLISH.getValue());
        wrapper.ne(AppClient::getId, (Object)appClient.getId());
        wrapper.set(AppClient::getPublish, (Object)PublishEnum.CANCELPUBLISH.getValue());
        this.appClientMapper.update(null, (Wrapper)wrapper);
        LambdaUpdateWrapper wrapper2 = new LambdaUpdateWrapper();
        wrapper2.eq(AppClient::getAppId, (Object)appClient.getAppId());
        wrapper2.eq(AppClient::getVersion, (Object)appClient.getVersion());
        wrapper2.eq(AppClient::getDelFlag, (Object)DelFlagEnum.UNDELETE.getValue());
        wrapper2.eq(AppClient::getValid, (Object)ValidEnum.VALID.getValue());
        wrapper2.ne(AppClient::getId, (Object)appClient.getId());
        wrapper2.set(AppClient::getValid, (Object)ValidEnum.INVALID.getValue());
        this.appClientMapper.update(null, (Wrapper)wrapper2);
    }

    public void unrelease(AppClient appClient) {
        if (appClient == null) {
            return;
        }
        appClient.setPublish(PublishEnum.CANCELPUBLISH.getValue()).clearTime();
        this.appClientMapper.updateById((Object)appClient);
    }

    public void deleteById(Long id) {
        if (id == null) {
            return;
        }
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        wrapper.eq(AppClient::getId, (Object)id);
        wrapper.eq(AppClient::getDelFlag, (Object)DelFlagEnum.UNDELETE.getValue());
        wrapper.set(AppClient::getDelFlag, (Object)DelFlagEnum.DELETE.getValue());
        this.appClientMapper.update(null, (Wrapper)wrapper);
    }
}

