/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.versionManage.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.mobile.mobileuibot.mapper.db2.AppConditionItemMapper;
import com.digiwin.mobile.mobileuibot.mock.enums.DelFlagEnum;
import com.digiwin.mobile.mobileuibot.model.db2.AppConditionItem;
import com.digiwin.mobile.mobileuibot.versionManage.request.AppConditionItemRequest;
import com.digiwin.mobile.mobileuibot.versionManage.service.AppConditionItemService;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AppConditionItemServiceImpl
extends ServiceImpl<AppConditionItemMapper, AppConditionItem>
implements AppConditionItemService {
    @Autowired
    private AppConditionItemMapper appConditionItemMapper;

    public List<AppConditionItem> selectByAppConditionId(Long appConditionId) {
        if (appConditionId == null) {
            return null;
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(AppConditionItem::getAppConditionId, (Object)appConditionId);
        wrapper.eq(AppConditionItem::getDelFlag, (Object)DelFlagEnum.UNDELETE.getValue());
        wrapper.orderByAsc(AppConditionItem::getId);
        return this.appConditionItemMapper.selectList((Wrapper)wrapper);
    }

    public List<AppConditionItem> selectByAppConditionIds(Set<Long> appConditionIds) {
        if (appConditionIds == null || appConditionIds.isEmpty()) {
            return null;
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.in(AppConditionItem::getAppConditionId, appConditionIds);
        wrapper.eq(AppConditionItem::getDelFlag, (Object)DelFlagEnum.UNDELETE.getValue());
        wrapper.orderByAsc(AppConditionItem::getId);
        return this.appConditionItemMapper.selectList((Wrapper)wrapper);
    }

    public void add(Long appConditionId, List<AppConditionItemRequest> itemList) {
        if (appConditionId == null || CollectionUtils.isEmpty(itemList)) {
            return;
        }
        List list = itemList.stream().map(item -> new AppConditionItem().setId(null).setAppConditionId(appConditionId).setSchema(item.getSchema()).setName(item.getName()).setSymbol(item.getSymbol()).setComponent(item.getComponent()).setContent(item.contentCovert()).setVerify(item.verifyCovert()).setDelFlag(DelFlagEnum.UNDELETE.getValue())).collect(Collectors.toList());
        this.saveBatch(list);
    }

    public void update(Long appConditionId, List<AppConditionItemRequest> itemList) {
        if (appConditionId == null) {
            return;
        }
        if (CollectionUtils.isEmpty(itemList)) {
            itemList = new ArrayList<AppConditionItemRequest>();
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(AppConditionItem::getAppConditionId, (Object)appConditionId);
        wrapper.eq(AppConditionItem::getDelFlag, (Object)DelFlagEnum.UNDELETE.getValue());
        Set oldItemIds = this.appConditionItemMapper.selectList((Wrapper)wrapper).stream().map(AppConditionItem::getId).collect(Collectors.toSet());
        Set itemIds = itemList.stream().map(AppConditionItemRequest::getId).filter(Objects::nonNull).collect(Collectors.toSet());
        Set deleteIds = oldItemIds.stream().filter(id -> !itemIds.contains(id)).collect(Collectors.toSet());
        if (CollectionUtils.isNotEmpty(deleteIds)) {
            LambdaUpdateWrapper deleteWrapper = new LambdaUpdateWrapper();
            deleteWrapper.in(AppConditionItem::getId, deleteIds);
            deleteWrapper.eq(AppConditionItem::getAppConditionId, (Object)appConditionId);
            deleteWrapper.eq(AppConditionItem::getDelFlag, (Object)DelFlagEnum.UNDELETE.getValue());
            deleteWrapper.set(AppConditionItem::getDelFlag, (Object)DelFlagEnum.DELETE.getValue());
            this.appConditionItemMapper.update(null, (Wrapper)deleteWrapper);
        }
        if (CollectionUtils.isEmpty(itemList)) {
            return;
        }
        List newItemList = itemList.stream().map(item -> {
            if (item.getId() == null) {
                return new AppConditionItem().setId(null).setAppConditionId(appConditionId).setSchema(item.getSchema()).setName(item.getName()).setSymbol(item.getSymbol()).setComponent(item.getComponent()).setContent(item.contentCovert()).setVerify(item.verifyCovert()).setDelFlag(DelFlagEnum.UNDELETE.getValue());
            }
            return new AppConditionItem().setId(item.getId()).setAppConditionId(appConditionId).setSchema(item.getSchema()).setName(item.getName()).setSymbol(item.getSymbol()).setComponent(item.getComponent()).setContent(item.contentCovert()).setVerify(item.verifyCovert()).setDelFlag(DelFlagEnum.UNDELETE.getValue());
        }).collect(Collectors.toList());
        this.saveOrUpdateBatch(newItemList);
    }

    public void deleteByAppConditionId(Long appConditionId) {
        if (appConditionId == null) {
            return;
        }
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        wrapper.eq(AppConditionItem::getAppConditionId, (Object)appConditionId);
        wrapper.eq(AppConditionItem::getDelFlag, (Object)DelFlagEnum.UNDELETE.getValue());
        wrapper.set(AppConditionItem::getDelFlag, (Object)DelFlagEnum.DELETE.getValue());
        this.appConditionItemMapper.update(null, (Wrapper)wrapper);
    }
}

