/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.versionManage.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.mapper.db2.AppUserClientRecordMapper;
import com.digiwin.mobile.mobileuibot.model.db2.AppUserClientRecord;
import com.digiwin.mobile.mobileuibot.versionManage.request.AppUpgradeReq;
import com.digiwin.mobile.mobileuibot.versionManage.service.AppUserClientRecordService;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AppUserClientRecordServiceImpl
implements AppUserClientRecordService {
    private static final Logger log = LoggerFactory.getLogger(AppUserClientRecordServiceImpl.class);
    public static BlockingDeque<AppUserClientRecord> BLOCKING_DEQUE = new LinkedBlockingDeque(1000);
    private final AppUserClientRecordMapper appUserClientRecordMapper;

    @Autowired
    public AppUserClientRecordServiceImpl(AppUserClientRecordMapper appUserClientRecordMapper) {
        this.appUserClientRecordMapper = appUserClientRecordMapper;
        this.initConsumer();
    }

    private void initConsumer() {
        Thread consumerThread = new Thread(() -> {
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(50L);
                        AppUserClientRecord appUserClientRecord = (AppUserClientRecord)BLOCKING_DEQUE.poll(500L, TimeUnit.MILLISECONDS);
                        if (appUserClientRecord == null) continue;
                        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
                        wrapper.eq(AppUserClientRecord::getUserId, (Object)appUserClientRecord.getUserId());
                        wrapper.eq(AppUserClientRecord::getDeviceId, (Object)appUserClientRecord.getDeviceId());
                        if (this.appUserClientRecordMapper.exists((Wrapper)wrapper)) {
                            this.appUserClientRecordMapper.update((Object)appUserClientRecord, (Wrapper)wrapper);
                            continue;
                        }
                        this.appUserClientRecordMapper.insert((Object)appUserClientRecord);
                    }
                }
                catch (Exception e) {
                    log.error("app\u7528\u6237\u5ba2\u6237\u7aef\u8bb0\u5f55 \u4fdd\u5b58\u5f02\u5e38", (Throwable)e);
                    continue;
                }
                break;
            }
        }, "app_user_client_record-Consumer");
        consumerThread.setDaemon(true);
        consumerThread.start();
    }

    public void asyncStorage(AppUpgradeReq vo) {
        try {
            if (StringUtils.isBlank((CharSequence)vo.getUserId())) {
                return;
            }
            AppUserClientRecord appUserClientRecord = (AppUserClientRecord)JsonUtil.objectToJavaObject((Object)vo, AppUserClientRecord.class);
            if (!BLOCKING_DEQUE.offer(appUserClientRecord)) {
                log.warn("app\u7528\u6237\u5ba2\u6237\u7aef\u8bb0\u5f55 \u961f\u5217\u5df2\u6ee1\uff0c\u4e22\u5f03\u65e5\u5fd7: {}", (Object)JsonUtil.javaObjectToJsonString((Object)appUserClientRecord));
            }
        }
        catch (Exception e) {
            log.error("app\u7528\u6237\u5ba2\u6237\u7aef\u8bb0\u5f55 \u8f6c\u6362\u5f02\u5e38", (Throwable)e);
        }
    }
}

