/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.push.jpush.util;

import cn.jiguang.common.ClientConfig;
import cn.jiguang.common.connection.HttpProxy;
import cn.jpush.api.JPushClient;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JPushClientUtil {
    private static Logger logger = LoggerFactory.getLogger(JPushClientUtil.class);
    private static volatile Map<String, JPushClient> _clientsPool = new HashMap<String, JPushClient>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JPushClient getInstance(String appKey, String masterSecret) {
        if (!_clientsPool.containsKey(appKey)) {
            Class<JPushClientUtil> clazz = JPushClientUtil.class;
            synchronized (JPushClientUtil.class) {
                if (!_clientsPool.containsKey(appKey)) {
                    JPushClient client = new JPushClient(masterSecret, appKey, JPushClientUtil.getProxy(), JPushClientUtil.getConfig());
                    _clientsPool.put(appKey, client);
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return client;
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return _clientsPool.get(appKey);
            }
        }
        return _clientsPool.get(appKey);
    }

    private static HttpProxy getProxy() {
        HttpProxy proxy = null;
        Properties prop = System.getProperties();
        if ("true".equals(prop.getProperty("http.proxySet"))) {
            String proxyHost = null;
            int proxyPort = 80;
            proxyHost = prop.getProperty("http.proxyHost");
            String proxyPortStr = prop.getProperty("http.proxyPort");
            if (proxyPortStr != null) {
                proxyPort = Integer.parseInt(proxyPortStr);
            }
            proxy = new HttpProxy(proxyHost, proxyPort);
        }
        return proxy;
    }

    private static ClientConfig getConfig() {
        ClientConfig config = ClientConfig.getInstance();
        String newJpushHost = System.getProperties().getProperty("jpush.push.hostname");
        if (newJpushHost != null) {
            config.setPushHostName(newJpushHost);
        }
        return config;
    }
}

