/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.push.jpush.util;

import cn.jiguang.common.resp.APIConnectionException;
import cn.jiguang.common.resp.APIRequestException;
import cn.jpush.api.JPushClient;
import cn.jpush.api.push.PushResult;
import cn.jpush.api.push.model.Message;
import cn.jpush.api.push.model.Options;
import cn.jpush.api.push.model.Platform;
import cn.jpush.api.push.model.PushPayload;
import cn.jpush.api.push.model.SMS;
import cn.jpush.api.push.model.audience.Audience;
import cn.jpush.api.push.model.audience.AudienceTarget;
import cn.jpush.api.push.model.notification.AndroidNotification;
import cn.jpush.api.push.model.notification.IosNotification;
import cn.jpush.api.push.model.notification.PlatformNotification;
import com.digiwin.mobile.mobileuibot.push.jpush.constant.PushConstant;
import com.digiwin.mobile.mobileuibot.push.jpush.model.Notification;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class PushUtil {
    protected static final Logger LOG = LoggerFactory.getLogger(PushUtil.class);

    public static PushPayload buildPushAlertAll(String content) {
        return PushPayload.alertAll((String)content);
    }

    public static PushPayload buildPushAlert(Integer deviceType, String alias, Notification notification, String appComponent) {
        return PushUtil.getBuilder(deviceType, alias, notification.getApnsProduction()).setNotification(PushUtil.getAlert(deviceType, notification, appComponent)).setOptions(PushUtil.getAndroidOption(notification)).build();
    }

    private static Options getAndroidOption(Notification notification) {
        HashMap<String, Map<String, String>> channelV2 = new HashMap<String, Map<String, String>>(1);
        channelV2.put("huawei", PushUtil.getAndroidHuaweiOption(notification));
        channelV2.put("xiaomi", PushUtil.getAndroidXiaomiOption(notification));
        channelV2.put("oppo", PushUtil.getAndroidOppoOption(notification));
        channelV2.put("vivo", PushUtil.getAndroidVivoOption(notification));
        return Options.newBuilder().setClassification(1).setThirdPartyChannel(channelV2).build();
    }

    private static Map<String, String> getAndroidHuaweiOption(Notification notification) {
        HashMap<String, String> huaweiOption = new HashMap<String, String>(2);
        huaweiOption.put("importance", "NORMAL");
        huaweiOption.put("category", "WORK");
        return huaweiOption;
    }

    private static Map<String, String> getAndroidXiaomiOption(Notification notification) {
        HashMap<String, String> xiaomiOption = new HashMap<String, String>(2);
        xiaomiOption.put("channel_id", "109491");
        xiaomiOption.put("skip_quota", "true");
        return xiaomiOption;
    }

    private static Map<String, String> getAndroidOppoOption(Notification notification) {
        HashMap<String, String> oppoOption = new HashMap<String, String>(2);
        oppoOption.put("channel_id", "digiwin_mobile_notice");
        oppoOption.put("skip_quota", "true");
        return oppoOption;
    }

    private static Map<String, String> getAndroidVivoOption(Notification notification) {
        HashMap<String, String> vivoOption = new HashMap<String, String>(2);
        vivoOption.put("category", "TODO");
        vivoOption.put("distribution", "secondary_push");
        return vivoOption;
    }

    public static PushPayload buildPushAlert(Integer deviceType, String tag, String alias, String content) {
        PushPayload.Builder builder = PushPayload.newBuilder().setPlatform(PushUtil.getPlatform(deviceType)).setNotification(cn.jpush.api.push.model.notification.Notification.alert((Object)content));
        if (tag != null && alias != null) {
            builder.setAudience(Audience.newBuilder().addAudienceTarget(AudienceTarget.tag((String[])new String[]{tag})).addAudienceTarget(AudienceTarget.alias((String[])new String[]{alias})).build());
        } else if (tag != null) {
            builder.setAudience(Audience.tag((String[])new String[]{tag}));
        } else if (alias != null) {
            builder.setAudience(Audience.alias((String[])new String[]{alias}));
        }
        return builder.build();
    }

    public static PushPayload buildPushMessage(String content) {
        return PushPayload.messageAll((String)content);
    }

    public static PushPayload buildPushMessage(Integer deviceType, String alias, Notification notification) {
        return PushUtil.getBuilder(deviceType, alias, notification.getApnsProduction()).setMessage(PushUtil.getMessage(notification)).build();
    }

    public static Message getMessage(Notification notification) {
        Message.Builder builder = Message.newBuilder();
        String title = notification.getTitle();
        if (notification.getNotificationContent() != null) {
            builder.setTitle(title);
            builder.setMsgContent(notification.getNotificationContent());
        } else {
            builder.setMsgContent(title);
        }
        builder.addExtra("tID", notification.getTenantId());
        builder.addExtra("uID", notification.getUserId());
        builder.addExtra("sType", (Number)notification.getNotificationType());
        builder.addExtra("nID", notification.getNotificationID());
        if (!StringUtils.isEmpty((Object)notification.getNotificationType())) {
            builder.addExtra("notificationType", (Number)notification.getNotificationType());
        }
        if (!StringUtils.isEmpty((Object)notification.getTitle())) {
            builder.addExtra("notificationTitle", notification.getTitle());
        }
        if (!StringUtils.isEmpty((Object)notification.getTenantId())) {
            builder.addExtra("tenantId", notification.getTenantId());
        }
        return builder.build();
    }

    public static cn.jpush.api.push.model.notification.Notification getAlert(Integer deviceType, Notification notification, String appComponent) {
        if (PushConstant.DEVICE_TYPE_IOS.equals(deviceType)) {
            return PushUtil.getIosAlert(notification);
        }
        return PushUtil.getAndroidAlert(notification, appComponent);
    }

    public static cn.jpush.api.push.model.notification.Notification getAndroidAlert(Notification notification, String appComponent) {
        AndroidNotification.Builder builder = AndroidNotification.newBuilder();
        String title = notification.getTitle();
        if (notification.getNotificationContent() != null) {
            builder.setTitle(title);
            builder.setAlert((Object)notification.getNotificationContent());
        } else {
            builder.setAlert((Object)title);
        }
        JsonObject intent = new JsonObject();
        intent.addProperty("url", "intent:#Intent;component=" + appComponent + "/com.dajia.view.login.ui.SplashActivity;end");
        builder.addCustom("badge_add_num", (Number)1);
        builder.addCustom("badge_class", "com.dajia.view.login.ui.SplashActivity");
        builder.addCustom("uri_activity", "com.dajia.view.other.component.push.OpenClickActivity");
        builder.setIntent(intent);
        builder.addExtra("tID", notification.getTenantId());
        builder.addExtra("uID", notification.getUserId());
        builder.addExtra("sType", (Number)notification.getNotificationType());
        builder.addExtra("nID", notification.getNotificationID());
        if (!StringUtils.isEmpty((Object)notification.getNotificationType())) {
            builder.addExtra("notificationType", (Number)notification.getNotificationType());
        }
        if (!StringUtils.isEmpty((Object)notification.getTitle())) {
            builder.addExtra("notificationTitle", notification.getTitle());
        }
        if (!StringUtils.isEmpty((Object)notification.getTenantId())) {
            builder.addExtra("tenantId", notification.getTenantId());
        }
        return cn.jpush.api.push.model.notification.Notification.newBuilder().addPlatformNotification((PlatformNotification)builder.build()).build();
    }

    public static cn.jpush.api.push.model.notification.Notification getIosAlert(Notification notification) {
        IosNotification.Builder builder = IosNotification.newBuilder().autoBadge().setSound((Object)"default");
        String title = notification.getTitle();
        if (notification.getNotificationContent() != null) {
            builder.setAlert((Object)(title + "\n" + notification.getNotificationContent()));
        } else {
            builder.setAlert((Object)title);
        }
        builder.addExtra("tID", notification.getTenantId());
        builder.addExtra("uID", notification.getUserId());
        builder.addExtra("sType", (Number)notification.getNotificationType());
        builder.addExtra("nID", notification.getNotificationID());
        if (!StringUtils.isEmpty((Object)notification.getNotificationType())) {
            builder.addExtra("notificationType", (Number)notification.getNotificationType());
        }
        if (!StringUtils.isEmpty((Object)notification.getTitle())) {
            builder.addExtra("notificationTitle", notification.getTitle());
        }
        if (!StringUtils.isEmpty((Object)notification.getTenantId())) {
            builder.addExtra("tenantId", notification.getTenantId());
        }
        return cn.jpush.api.push.model.notification.Notification.newBuilder().addPlatformNotification((PlatformNotification)builder.build()).build();
    }

    public static PushPayload buildPushObject_all_alias_alert(String alias, String content) {
        return PushPayload.newBuilder().setPlatform(Platform.all()).setAudience(Audience.alias((String[])new String[]{alias})).setNotification(cn.jpush.api.push.model.notification.Notification.alert((Object)content)).build();
    }

    public static PushPayload buildPushObject_android_tag_alertWithTitle(String platform, String tag, String title, String content) {
        return PushPayload.newBuilder().setPlatform(Platform.android()).setAudience(Audience.tag((String[])new String[]{tag})).setNotification(cn.jpush.api.push.model.notification.Notification.android((String)content, (String)title, null)).build();
    }

    public static PushPayload buildPushObject_ios_tagAnd_alertWithExtrasAndMessage() {
        return PushPayload.newBuilder().setPlatform(Platform.ios()).setAudience(Audience.tag_and((String[])new String[]{"tag1", "tag_all"})).setNotification(cn.jpush.api.push.model.notification.Notification.newBuilder().addPlatformNotification((PlatformNotification)((IosNotification.Builder)IosNotification.newBuilder().setAlert((Object)"ALERT").setBadge(5).setSound((Object)"happy").addExtra("from", "JPush")).build()).build()).setMessage(Message.content((String)"MSG_CONTENT")).setOptions(Options.newBuilder().setApnsProduction(true).build()).build();
    }

    public static PushPayload buildPushObject_ios_audienceMore_messageWithExtras() {
        return PushPayload.newBuilder().setPlatform(Platform.android_ios()).setAudience(Audience.newBuilder().addAudienceTarget(AudienceTarget.tag((String[])new String[]{"tag1", "tag2"})).addAudienceTarget(AudienceTarget.alias((String[])new String[]{"alias1", "alias2"})).build()).setMessage(Message.newBuilder().setMsgContent("MSG_CONTENT").addExtra("from", "JPush").build()).build();
    }

    public static void testSendWithSMS(String masterSecret, String appKey) {
        JPushClient jpushClient = new JPushClient(masterSecret, appKey);
        try {
            SMS sms = SMS.content((String)"Test SMS", (int)10);
            PushResult result = jpushClient.sendAndroidMessageWithAlias("Test SMS", "test sms", sms, new String[]{"alias1"});
            LOG.debug("Got result - " + result);
        }
        catch (APIConnectionException e) {
            LOG.error("Connection error. Should retry later. ", (Throwable)e);
        }
        catch (APIRequestException e) {
            LOG.error("Error response from JPush server. Should review and fix it. ", (Throwable)e);
            LOG.debug("HTTP Status: " + e.getStatus());
            LOG.debug("Error Code: " + e.getErrorCode());
            LOG.debug("Error Message: " + e.getErrorMessage());
        }
    }

    public static PushPayload.Builder getBuilder(Integer deviceType, String alias, Boolean apnsProduction) {
        PushPayload.Builder builder = PushPayload.newBuilder();
        if (apnsProduction == null) {
            apnsProduction = true;
        }
        if (PushConstant.DEVICE_TYPE_IOS.equals(deviceType)) {
            builder.setOptions(Options.newBuilder().setApnsProduction(apnsProduction.booleanValue()).build());
        }
        builder.setPlatform(PushUtil.getPlatform(deviceType)).setAudience(Audience.alias((String[])new String[]{alias}));
        return builder;
    }

    private static Platform getPlatform(Integer deviceType) {
        if (deviceType == null) {
            return Platform.all();
        }
        if (PushConstant.DEVICE_TYPE_ANDROID.equals(deviceType)) {
            return Platform.android();
        }
        if (PushConstant.DEVICE_TYPE_IOS.equals(deviceType)) {
            return Platform.ios();
        }
        if (PushConstant.DEVICE_TYPE_WP.equals(deviceType)) {
            return Platform.winphone();
        }
        if (PushConstant.DEVICE_TYPE_ANDROID_IOS.equals(deviceType)) {
            return Platform.android_ios();
        }
        if (PushConstant.DEVICE_TYPE_ANDROID_WP.equals(deviceType)) {
            return Platform.android_winphone();
        }
        if (PushConstant.DEVICE_TYPE_IOS_WP.equals(deviceType)) {
            return Platform.ios_winphone();
        }
        return Platform.all();
    }
}

