/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.rabbitmq.listener;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.push.fcm.util.FcmClientUtil;
import com.digiwin.mobile.mobileuibot.push.jpush.model.Notification;
import com.rabbitmq.client.Channel;
import java.io.IOException;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.annotation.RabbitHandler;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.messaging.Message;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class DirectReceiver {
    private static final Logger log = LoggerFactory.getLogger(DirectReceiver.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RabbitHandler
    @RabbitListener(queues={"mobileDirectQueue"})
    public void process(Message<Notification> message, Channel channel) throws IOException {
        long deliveryTag = 0L;
        try {
            log.debug("DirectReceiver\u6d88\u8d39\u8005\u6536\u5230\u6d88\u606f  : " + JSONObject.toJSON((Object)message.getPayload()));
            deliveryTag = Long.parseLong(Objects.requireNonNull(message.getHeaders().get((Object)"amqp_deliveryTag")).toString());
            Notification notification = (Notification)JsonUtil.objectToJavaObject((Object)message.getPayload(), Notification.class);
            if (!CollectionUtils.isEmpty(notification.getFireBaseTokenList())) {
                notification.getFireBaseTokenList().forEach(token -> {
                    try {
                        FcmClientUtil.pushSingle("com.digiwin.enterprise.athena.atn", token, notification.getTitle(), JSONObject.toJSONString((Object)notification));
                    }
                    catch (Exception e) {
                        log.error("DirectReceiver\u6d88\u8d39\u8005 failed: " + e.getMessage(), (Throwable)e);
                    }
                });
            }
        }
        catch (Exception e) {
            log.error("DirectReceiver\u6d88\u8d39\u8005 failed: " + e.getMessage(), (Throwable)e);
            channel.basicNack(deliveryTag, false, false);
        }
        finally {
            channel.basicAck(deliveryTag, false);
        }
    }
}

