package com.digiwin.mobile.mobileuibot.push.jpush.model;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.List;

/**
 * 通知列表实体
 *
 * @author wuyang
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class Notification implements Serializable, Cloneable {

    private static final long serialVersionUID = -4277635794375753921L;
    private String notificationID;
    private String contentID;
    private String userId;

    private List<String> userIds;

    /**
     * fireBase消息使用
     */
    private List<String> fireBaseTokenList;
    /**
     * 用户名的别名
     */
    private String userSid;
    /**
     * 通知内容
     */
    private String notificationContent;
    /**
     * 通知类型
     */
    private Integer notificationType;
    /**
     * 是否已经读取
     */
    private Integer isRead;
    /**
     * 通知时间
     */
    private Timestamp notificationTime;
    /**
     * 链接地址
     */
    private String href;
    private String tenantId;
    private Integer isDeal;
    private String dealResult;
    private String title;
    private Integer subNotificationType;
    /**
     * 集成消息分类
     */
    private String sourceType = "SYSTEM";
    /**
     * 集成消息子分类
     */
    private String subSourceType;
    //通知来源
    private String fromUserID;
    /**
     * 查询开始时间   仅查询使用
     */
    private Timestamp startTime;
    /**
     * 查询结束时间   仅查询使用
     */
    private Timestamp endTime;
    /**
     * 通知对应公告ID
     */
    private String feedID;

    /**
     * 使用标记
     */
    private Integer pcType;
    private Integer mobileType;
    /**
     * 是否发送到iOS生产环境。true:生产环境；false:开发环境
     */
    private Boolean apnsProduction;


    @Override
    public Notification clone() {
        Notification notification = null;
        try {
            notification = (Notification) super.clone();
        } catch (CloneNotSupportedException e) {
        }
        return notification;
    }

}
