package com.digiwin.mobile.mobileuibot.push.jpush.service.impl;

import cn.jiguang.common.resp.APIConnectionException;
import cn.jiguang.common.resp.APIRequestException;
import cn.jpush.api.push.model.PushPayload;
import com.digiwin.mobile.mobileuibot.push.jpush.PushConfig;
import com.digiwin.mobile.mobileuibot.push.jpush.constant.PushConstant;
import com.digiwin.mobile.mobileuibot.push.jpush.model.Notification;
import com.digiwin.mobile.mobileuibot.push.jpush.service.PushSupplierEnable;
import com.digiwin.mobile.mobileuibot.push.jpush.util.JPushClientUtil;
import com.digiwin.mobile.mobileuibot.push.jpush.util.PushUtil;
import lombok.extern.slf4j.Slf4j;

import org.springframework.stereotype.Service;

/**
 * @author wuyangz
 * @date 2022-10-11
 */
@Slf4j
@Service(value = "jPushService")
public class JPushServiceImpl implements PushSupplierEnable {

    @Override
    public boolean pushAlert(Notification notification, PushConfig app) {
        //安卓使用通知
        boolean s1 = pushAlert(notification, app, PushConstant.DEVICE_TYPE_ANDROID);
        //ios使用通知
        boolean s2 = pushAlert(notification, app, PushConstant.DEVICE_TYPE_IOS);
        return s1 && s2;
    }

    @Override
    public boolean pushAlert(Notification notification, PushConfig app, Integer deviceType) {
        return pushAlert(notification, app, deviceType, 1);
    }


    @Override
    public boolean pushMessage(Notification notification, PushConfig app) {
        //全通道推送自定义消息
        PushPayload payload = PushUtil.buildPushMessage(
                PushConstant.DEVICE_TYPE_ALL, notification.getUserId(), notification);
        int code = sendPush(payload, app);
        return code == 1;
    }

    @Override
    public boolean pushMessage(Notification notification, PushConfig app, Integer deviceType) {
        return pushMessage(notification, app, deviceType, 1);
    }


    private boolean pushAlert(Notification notification, PushConfig app, Integer deviceType, int reTimes) {
        StringBuilder sb = new StringBuilder("push notification(").append(reTimes);
        sb.append("):device:" + deviceType + ",id:").append(notification.getNotificationID())
                .append(",uID:").append(notification.getUserId())
                .append(",tID:").append(notification.getTenantId()).append(",title:").append(notification.getTitle())
                .append(",content:").append(notification.getNotificationContent())
                .append(",notificationType:").append(notification.getNotificationType())
                .append(",notificationTitle:").append(notification.getTitle());
        log.debug(sb.toString());
        PushPayload payload = PushUtil.buildPushAlert(deviceType, notification.getUserId(), notification, app.getJpushAndroidIntentComponent());
        int code = sendPush(payload, app);
        return code == 1;
    }

    private boolean pushMessage(Notification notification, PushConfig app, Integer deviceType, int reTimes) {
        StringBuilder sb = new StringBuilder("push notification(").append(reTimes);
        sb.append("):device:" + deviceType + ",id:").append(notification.getNotificationID())
                .append(",uID:").append(notification.getUserId())
                .append(",tID:").append(notification.getTenantId()).append(",title:").append(notification.getTitle())
                .append(",content:").append(notification.getNotificationContent())
                .append(",notificationType:").append(notification.getNotificationType())
                .append(",notificationTitle:").append(notification.getTitle());
        log.debug(sb.toString());
        PushPayload payload = PushUtil.buildPushMessage(deviceType, notification.getUserId(), notification);
        int code = sendPush(payload, app);
        return code == 1;
    }


    /**
     * 发送离线消息、通知
     *
     * @param payload
     * @param app
     * @return -1:需要重发
     */
    private int sendPush(PushPayload payload, PushConfig app) {

        try {
            JPushClientUtil.getInstance(app.getAppkey(), app.getMasterSecret()).sendPush(payload);
            return 1;
        } catch (APIConnectionException e) {
            /**
             * 网络超时 需要重发
             */
            log.error("极光推送网络失败，已经重试：" + e.getDoneRetriedTimes() + "次，" +
                    "是否读取超时：" + e.isReadTimedout());
            e.printStackTrace();
            return -1;
        } catch (APIRequestException e) {
            if (e.getErrorCode() == 1011 || e.getErrorCode() == 2002) {
                log.error("error code:" + e.getErrorCode() + " : " + e.getErrorMessage());
            } else {
                log.error("error code:" + e.getErrorCode() + " : " + e.getErrorMessage(), e);
            }
            /**
             * 超频 需要重发
             */
            if (e.getErrorCode() == 2002) {
                return -1;
            }
        } catch (Exception e) {
            log.error("push error", e);
        }
        return 0;
    }
}
