package com.digiwin.mobile.mobileuibot.rabbitmq.config;

import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.core.TopicExchange;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * 主题交换机配置
 *
 * @author wuyang
 * @date 20230627
 */
@Configuration
public class TopicRabbitConfig {

    public final static String MOBILE_TOPIC_TENANT = "mobile.topic.tenant";
    public final static String MOBILE_TOPIC_EXCHANGE = "mobileTopicExchange";

    @Bean
    public Queue mobileTopicTenantQueue() {
        return new Queue(TopicRabbitConfig.MOBILE_TOPIC_TENANT);
    }

    @Bean
    TopicExchange exchange() {
        return new TopicExchange(MOBILE_TOPIC_EXCHANGE);
    }

    /**
     * 将mobileTopicTenantQueue和topicExchange绑定,而且绑定的键值为mobile.topic.tenant
     * 这样只要是消息携带的路由键是mobile.topic.tenant,才会分发到该队列
     */
    @Bean
    Binding bindingExchangeMessage() {
        return BindingBuilder.bind(mobileTopicTenantQueue()).to(exchange()).with(MOBILE_TOPIC_TENANT);
    }

}
