package com.digiwin.mobile.mobileuibot.rabbitmq.confirm;


import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.rabbit.connection.CorrelationData;
import org.springframework.amqp.rabbit.core.RabbitTemplate;

/**
 * @author yanfeng
 * @date 2023/7/21
 */
@Slf4j
//@Component
public class ExchangeCallback implements RabbitTemplate.ConfirmCallback {

    /**
     * 当消息由生产者发到交换机后会回调该接口中的confirm方法
     *
     * @param correlationData 消息内容
     * @param ack             交换机接受成功或者失败。 true表示交换机接受消息成功， false表示交换机接受失败
     * @param cause           表示失败原因
     */
    @Override
    public void confirm(CorrelationData correlationData, boolean ack, String cause) {
        System.out.println("hello world");
        String id = correlationData.getId();
        String message = new String(correlationData.getReturned().getMessage().getBody());
        if (ack) {
            log.debug("交换机收到消息id为{}, 消息内容为{}", id, message);
        } else {
            log.debug("交换机未收到消息id为{}, 消息内容为{}, 原因为{}", id, message, cause);
        }
    }

}

