package com.digiwin.mobile.mobileuibot.rabbitmq.listener;

import com.digiwin.mobile.mobileuibot.rabbitmq.config.FanoutRabbitConfig;
import org.springframework.amqp.rabbit.annotation.RabbitHandler;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * 扇形区消息推送队列
 *
 * @author wuyang
 * @date 20230627
 */
@Component
@RabbitListener(queues = {FanoutRabbitConfig.MOBILE_FANOUT_FCM_TENANT, FanoutRabbitConfig.MOBILE_FANOUT_FCM_COMPANY})
public class FanoutReceiver {

    @RabbitHandler
    public void process(Map testMessage) {
        System.out.println("FanoutReceiver消费者收到消息  : " + testMessage.toString());
    }
}
