package com.digiwin.mobile.mobileuibot.rabbitmq.listener;

import com.digiwin.mobile.mobileuibot.rabbitmq.config.TopicRabbitConfig;
import org.springframework.amqp.rabbit.annotation.RabbitHandler;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * 监听主题类推送队列
 *
 * @author wuyang
 * @date 20230627
 */
@Component
@RabbitListener(queues = TopicRabbitConfig.MOBILE_TOPIC_TENANT)
public class TopicReceiver {

    @RabbitHandler
    public void process(Map testMessage) {
        System.out.println("TopicpReceiver消费者收到消息  : " + testMessage.toString());
    }
}
