package com.digiwin.mobile.mobileuibot.rabbitmq.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.common.calculate.UUIDUtil;
import com.digiwin.mobile.mobileuibot.push.jpush.model.Notification;
import com.digiwin.mobile.mobileuibot.rabbitmq.config.DirectRabbitConfig;
import com.digiwin.mobile.mobileuibot.rabbitmq.config.FanoutRabbitConfig;
import com.digiwin.mobile.mobileuibot.rabbitmq.config.TopicRabbitConfig;
import com.digiwin.mobile.mobileuibot.rabbitmq.service.PushService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;

/**
 * 推送使用的service类
 * 发送者
 *
 * @author wuyang
 * @date 20230627
 */
@Slf4j
@Service("pushService")
public class PushServiceImpl implements PushService {

    @Autowired
    private RabbitTemplate rabbitTemplate;

    @Override
    public Boolean sendMobileDirectMessage(Notification notification) {
        try {
            //将消息携带绑定键值：mobileDirectRouting 发送到交换机mobileDirectExchange
            rabbitTemplate.convertAndSend(DirectRabbitConfig.MOBILE_DIRECT_EXCHANGE, DirectRabbitConfig.MOBILE_DIRECT_ROUTING, notification);
            log.debug("sendMobileDirectMessage消息发送成功：{}", JSONObject.toJSONString(notification));
        } catch (Exception e) {
            log.error("sendMobileDirectMessage发送失败：" + e.getMessage());
            return false;
        }
        return true;
    }

    @Override
    public Boolean sendTopicMessage(String messageData) {
        Map<String, Object> map = new HashMap<>(3);
        map.put("messageId", UUIDUtil.getUuid());
        map.put("messageData", messageData);
        map.put("createTime", LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        try {
            //将消息携带绑定键值：mobileDirectRouting 发送到交换机mobileDirectExchange
            rabbitTemplate.convertAndSend(TopicRabbitConfig.MOBILE_TOPIC_EXCHANGE, TopicRabbitConfig.MOBILE_TOPIC_TENANT, map);
        } catch (Exception e) {
            log.error("发送失败：" + e.getMessage());
            return false;
        }
        return true;
    }

    @Override
    public Boolean sendFanoutMessage(String messageData) {
        Map<String, Object> map = new HashMap<>(3);
        map.put("messageId", UUIDUtil.getUuid());
        map.put("messageData", messageData);
        map.put("createTime", LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        try {
            //将消息携带绑定键值：mobileDirectRouting 发送到交换机mobileDirectExchange
            rabbitTemplate.convertAndSend(FanoutRabbitConfig.MOBILE_FANOUT_EXCHANGE, null, map);
        } catch (Exception e) {
            log.error("发送失败：" + e.getMessage());
            return false;
        }
        return true;
    }
}
