/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.push.fcm.util;

import com.digiwin.mobile.mobileuibot.common.datetime.DateTimeUtil;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.firebase.FirebaseApp;
import com.google.firebase.FirebaseOptions;
import com.google.firebase.messaging.FirebaseMessaging;
import com.google.firebase.messaging.FirebaseMessagingException;
import com.google.firebase.messaging.Message;
import com.google.firebase.messaging.Notification;
import com.google.firebase.messaging.TopicManagementResponse;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;

public class FcmClientUtil {
    private static Logger logger = LoggerFactory.getLogger(FcmClientUtil.class);
    private static volatile Map<String, FirebaseApp> firebaseAppMap = new ConcurrentHashMap<String, FirebaseApp>();
    private static final String KEY_PATH = "serviceAccountKey.json";
    private static final String DATA_URL = "";
    public static final String APP_NAME = "com.digiwin.enterprise.athena.atn";
    public static final String TEST_TOKEN = "ea51s4s3SFCIwD7mZEAi-c:APA91bF0uRhHqJzhpqFsQJPkjBaoqN7nYvju6mRXAoZlXdOvp8VSU-VTmsBX8avNnXBY_9QWzXH_KRXdy9mJ4dG5WVGeTyG1Jpa3GIXkVb2F2maTGR3ACMNRY0WJqMw5hMJ1AD2cvAwS";

    public static Boolean isInit(String appName) {
        return firebaseAppMap.get(appName) != null;
    }

    public static void init(String appName) throws IOException {
        FirebaseApp firebaseApp;
        block2: {
            ClassPathResource classPathResource = new ClassPathResource(KEY_PATH);
            FirebaseOptions options = new FirebaseOptions.Builder().setCredentials(GoogleCredentials.fromStream((InputStream)classPathResource.getInputStream())).build();
            firebaseApp = null;
            try {
                firebaseApp = FirebaseApp.initializeApp((FirebaseOptions)options);
            }
            catch (Exception e) {
                firebaseApp = FirebaseApp.getInstance((String)appName);
                if (firebaseApp == null) break block2;
                firebaseApp.delete();
                firebaseApp = FirebaseApp.initializeApp((FirebaseOptions)options);
            }
        }
        firebaseAppMap.put(APP_NAME, firebaseApp);
    }

    public static void pushSingle(String appName, String token, String title, String body) throws FirebaseMessagingException, IOException {
        FirebaseApp firebaseApp;
        if (!FcmClientUtil.isInit(appName).booleanValue()) {
            FcmClientUtil.init(appName);
        }
        if ((firebaseApp = firebaseAppMap.get(appName)) == null) {
            return;
        }
        Message message = Message.builder().setNotification(Notification.builder().setTitle(title).setBody(body).build()).setToken(token).build();
        String response = FirebaseMessaging.getInstance((FirebaseApp)firebaseApp).send(message);
        logger.debug("firebase\u53d1\u9001\u6d88\u606f\u6210\u529f,FirebaseID:" + response + ",\u8bbe\u5907:" + token + ",\u4e8e" + DateTimeUtil.getTodayTimeUseDefaultPattern() + "\u63a8\u9001\u6d88\u606ftitle:" + title + ",\u6d88\u606f\u5185\u5bb9:" + body);
    }

    public static void registrationTopic(String appName, List<String> tokens, String topic) throws FirebaseMessagingException, IOException {
        FirebaseApp firebaseApp;
        if (!FcmClientUtil.isInit(appName).booleanValue()) {
            FcmClientUtil.init(appName);
        }
        if ((firebaseApp = firebaseAppMap.get(appName)) == null) {
            return;
        }
        TopicManagementResponse response = FirebaseMessaging.getInstance((FirebaseApp)firebaseApp).subscribeToTopic(tokens, topic);
        logger.error("\u6dfb\u52a0\u8bbe\u5907\u4e3b\u9898\uff0c\u6210\u529f\uff1a" + response.getSuccessCount() + ",\u5931\u8d25\uff1a" + response.getFailureCount());
    }

    public static void cancelTopic(String appName, List<String> tokens, String topic) throws FirebaseMessagingException, IOException {
        FirebaseApp firebaseApp;
        if (!FcmClientUtil.isInit(appName).booleanValue()) {
            FcmClientUtil.init(appName);
        }
        if ((firebaseApp = firebaseAppMap.get(appName)) == null) {
            return;
        }
        TopicManagementResponse response = FirebaseMessaging.getInstance((FirebaseApp)firebaseApp).unsubscribeFromTopic(tokens, topic);
        logger.error("\u53d6\u6d88\u8bbe\u5907\u4e3b\u9898\uff0c\u6210\u529f\uff1a" + response.getSuccessCount() + ",\u5931\u8d25\uff1a" + response.getFailureCount());
    }

    public static void sendTopicMes(String appName, String topic, String title, String body) throws FirebaseMessagingException, IOException {
        FirebaseApp firebaseApp;
        if (!FcmClientUtil.isInit(appName).booleanValue()) {
            FcmClientUtil.init(appName);
        }
        if ((firebaseApp = firebaseAppMap.get(appName)) == null) {
            return;
        }
        Message message = Message.builder().setNotification(Notification.builder().setTitle(title).setBody(body).build()).setTopic(topic).build();
        String response = FirebaseMessaging.getInstance((FirebaseApp)firebaseApp).send(message);
        logger.error("\u4e3b\u9898\u63a8\u9001\u6210\u529f: " + response);
    }

    public static void main(String[] args) throws Exception {
        FcmClientUtil.initProxy("127.0.0.1", 33210, DATA_URL, DATA_URL);
        FcmClientUtil.pushSingle(APP_NAME, TEST_TOKEN, "\u6d4b\u8bd5FCM", "\u60a8\u597d\uff0c\u9f0e\u6377\u79fb\u52a8\u6b63\u5728\u6d4b\u8bd5FCM\uff0c\u6536\u5230\u8bf7\u5ffd\u7565~");
    }

    private static void initProxy(String host, int port, String username, String password) {
        System.setProperty("jdk.http.auth.tunneling.disabledSchemes", "33210");
        System.setProperty("http.proxyHost", host);
        System.setProperty("http.proxyPort", Integer.toString(port));
        System.setProperty("https.proxyHost", host);
        System.setProperty("https.proxyPort", Integer.toString(port));
    }
}

