/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.push.jpush.service.impl;

import cn.jiguang.common.resp.APIConnectionException;
import cn.jiguang.common.resp.APIRequestException;
import cn.jpush.api.push.model.PushPayload;
import com.digiwin.mobile.mobileuibot.push.jpush.PushConfig;
import com.digiwin.mobile.mobileuibot.push.jpush.constant.PushConstant;
import com.digiwin.mobile.mobileuibot.push.jpush.model.Notification;
import com.digiwin.mobile.mobileuibot.push.jpush.service.PushSupplierEnable;
import com.digiwin.mobile.mobileuibot.push.jpush.util.JPushClientUtil;
import com.digiwin.mobile.mobileuibot.push.jpush.util.PushUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="jPushService")
public class JPushServiceImpl
implements PushSupplierEnable {
    private static final Logger log = LoggerFactory.getLogger(JPushServiceImpl.class);

    @Override
    public boolean pushAlert(Notification notification, PushConfig app) {
        boolean s1 = this.pushAlert(notification, app, PushConstant.DEVICE_TYPE_ANDROID);
        boolean s2 = this.pushAlert(notification, app, PushConstant.DEVICE_TYPE_IOS);
        return s1 && s2;
    }

    @Override
    public boolean pushAlert(Notification notification, PushConfig app, Integer deviceType) {
        return this.pushAlert(notification, app, deviceType, 1);
    }

    @Override
    public boolean pushMessage(Notification notification, PushConfig app) {
        PushPayload payload = PushUtil.buildPushMessage(PushConstant.DEVICE_TYPE_ALL, notification.getUserId(), notification);
        int code = this.sendPush(payload, app);
        return code == 1;
    }

    @Override
    public boolean pushMessage(Notification notification, PushConfig app, Integer deviceType) {
        return this.pushMessage(notification, app, deviceType, 1);
    }

    private boolean pushAlert(Notification notification, PushConfig app, Integer deviceType, int reTimes) {
        StringBuilder sb = new StringBuilder("push notification(").append(reTimes);
        sb.append("):device:" + deviceType + ",id:").append(notification.getNotificationID()).append(",uID:").append(notification.getUserId()).append(",tID:").append(notification.getTenantId()).append(",title:").append(notification.getTitle()).append(",content:").append(notification.getNotificationContent()).append(",notificationType:").append(notification.getNotificationType()).append(",notificationTitle:").append(notification.getTitle());
        log.debug(sb.toString());
        PushPayload payload = PushUtil.buildPushAlert(deviceType, notification.getUserId(), notification, app.getJpushAndroidIntentComponent());
        int code = this.sendPush(payload, app);
        return code == 1;
    }

    private boolean pushMessage(Notification notification, PushConfig app, Integer deviceType, int reTimes) {
        StringBuilder sb = new StringBuilder("push notification(").append(reTimes);
        sb.append("):device:" + deviceType + ",id:").append(notification.getNotificationID()).append(",uID:").append(notification.getUserId()).append(",tID:").append(notification.getTenantId()).append(",title:").append(notification.getTitle()).append(",content:").append(notification.getNotificationContent()).append(",notificationType:").append(notification.getNotificationType()).append(",notificationTitle:").append(notification.getTitle());
        log.debug(sb.toString());
        PushPayload payload = PushUtil.buildPushMessage(deviceType, notification.getUserId(), notification);
        int code = this.sendPush(payload, app);
        return code == 1;
    }

    private int sendPush(PushPayload payload, PushConfig app) {
        try {
            JPushClientUtil.getInstance(app.getAppkey(), app.getMasterSecret()).sendPush(payload);
            return 1;
        }
        catch (APIConnectionException e) {
            log.error("\u6781\u5149\u63a8\u9001\u7f51\u7edc\u5931\u8d25\uff0c\u5df2\u7ecf\u91cd\u8bd5\uff1a" + e.getDoneRetriedTimes() + "\u6b21\uff0c\u662f\u5426\u8bfb\u53d6\u8d85\u65f6\uff1a" + e.isReadTimedout());
            e.printStackTrace();
            return -1;
        }
        catch (APIRequestException e) {
            if (e.getErrorCode() == 1011 || e.getErrorCode() == 2002) {
                log.error("error code:" + e.getErrorCode() + " : " + e.getErrorMessage());
            } else {
                log.error("error code:" + e.getErrorCode() + " : " + e.getErrorMessage(), (Throwable)e);
            }
            if (e.getErrorCode() == 2002) {
                return -1;
            }
        }
        catch (Exception e) {
            log.error("push error", (Throwable)e);
        }
        return 0;
    }
}

