package com.digiwin.monitor.scan.sdk;

import com.digiwin.monitor.scan.sdk.enumerate.DbType;
import com.digiwin.monitor.scan.sdk.parse.RespParser;
import com.digiwin.monitor.scan.sdk.parse.SqlParser;
import com.digiwin.monitor.scan.sdk.pojo.request.DataChangeGetRequest;
import com.digiwin.monitor.scan.sdk.pojo.request.Rule;
import com.digiwin.monitor.scan.sdk.pojo.response.DataChangeGetResponse;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @description: data.change.get处理demo
 * @author: liunansheng
 * @date: 2021/11/25 17:51
 */
public abstract class AbstractDataChangeGetService {

    public AbstractDataChangeGetService() {
        if (!DataChangeGetExtensionContext.isIsInit()) {
            DataChangeGetExtensionContext.initContext(this.getExtensionClassPackage(), this.getDbType());
        }
    }

    final public List<DataChangeGetResponse> dataChangeGet(DataChangeGetRequest request) {
        List<DataChangeGetResponse> resultList = new ArrayList<>();
        //目前只会下发一条规则
        for (Rule rule : request.getRules()) {
            //转换sql
            String sql = SqlParser.parse(request, rule);

            //伪代码，查询数据，根据自身系统实现sql查询数据
            List<Map<String,Object>> data = searchData(sql);

            //转换返回结果
            List<Map<String,Object>> convertResult = RespParser.convertResp(data, rule.getAction_params());
            resultList.add(new DataChangeGetResponse(rule.getRule_id(), convertResult));
        }
        return resultList;
    }

    /**
     * 实现根据sql查询数据
     * @param sql
     * @return
     */
    protected abstract List<Map<String,Object>> searchData(String sql);


    /**
     * 当平台能满足功能，不需要额外做定制化时无需实现此方法
     * 当需要定制化时，实现此方法，并返回定制化实现类的包路径: com.xxx.xxx
     * @return
     */
    protected String getExtensionClassPackage() {
        return null;
    }

    /**
     * 数据库类型，默认时Mysql，如果不是mysql请覆盖此方法，返回对应的数据库类型
     * @see DbType
     * @return
     */
    protected DbType getDbType() {
        return DbType.MYSQL;
    }

}
