package com.digiwin.monitor.scan.sdk;

import com.digiwin.monitor.scan.sdk.enumerate.DbType;
import com.digiwin.monitor.scan.sdk.extension.*;
import com.digiwin.monitor.scan.sdk.extension.impl.ApprovedTypeDefaultParamBuilderImpl;
import com.digiwin.monitor.scan.sdk.extension.impl.CreatedTypeDefaultParamBuilderImpl;
import com.digiwin.monitor.scan.sdk.extension.impl.ModifiedTypeDefaultParamBuilderImpl;
import com.digiwin.monitor.scan.sdk.extension.impl.OpRightValConvertorImpl;
import com.digiwin.monitor.scan.sdk.util.ClassScanUtil;
import com.digiwin.monitor.scan.sdk.util.CollectionUtil;
import com.digiwin.monitor.scan.sdk.util.StringUtil;

import java.util.List;

/**
 * @description: 基础配置，比如数据库类型
 * @author: liunansheng
 * @date: 2021/11/25 19:02
 */
public class DataChangeGetExtensionContext {
    private static boolean isInit;
    /**
     * 数据库类型,demo会根据数据库类型做一定的兼容
     * 目前针对like语句做了兼容
     */
    private static DbType DB_TYPE = DbType.MYSQL;

    private static IApprovedTypeDefaultParamBuilder approvedTypeDefaultParamBuilder;

    private static ICreatedTypeDefaultParamBuilder createdTypeDefaultParamBuilder;

    private static IModifiedTypeDefaultParamBuilder modifiedTypeDefaultParamBuilder;

    private static IOpRightValConvertor opRightValConvertor;

    private static IOtherWhereConditionAdder otherWhereConditionAdder;


    synchronized static void initContext(String extensionPackageName, DbType dbType) {
        if (isInit) {
            return;
        }
        /** 初始化数据库类型 */
        if (dbType != null) {
            DB_TYPE = dbType;
        }
        /** 加载定制化扩展点 */
        if (StringUtil.isBlank(extensionPackageName)) {
           buildDefaultExtension();
           return;
        }
        try {
            List<Class> classList = ClassScanUtil.scanClass(extensionPackageName);
            if (CollectionUtil.isEmpty(classList)) {
                buildDefaultExtension();
                return;
            }
            for (Class extensionClass : classList) {
                if (IApprovedTypeDefaultParamBuilder.class.isAssignableFrom(extensionClass)) {
                    approvedTypeDefaultParamBuilder = (IApprovedTypeDefaultParamBuilder) extensionClass.newInstance();
                } else if (ICreatedTypeDefaultParamBuilder.class.isAssignableFrom(extensionClass)) {
                    createdTypeDefaultParamBuilder = (ICreatedTypeDefaultParamBuilder) extensionClass.newInstance();
                } else if (IModifiedTypeDefaultParamBuilder.class.isAssignableFrom(extensionClass)) {
                    modifiedTypeDefaultParamBuilder = (IModifiedTypeDefaultParamBuilder) extensionClass.newInstance();
                } else if (IOpRightValConvertor.class.isAssignableFrom(extensionClass)) {
                    opRightValConvertor = (IOpRightValConvertor) extensionClass.newInstance();
                } else if (IOtherWhereConditionAdder.class.isAssignableFrom(extensionClass)) {
                    otherWhereConditionAdder = (IOtherWhereConditionAdder) extensionClass.newInstance();
                }
            }
            buildDefaultExtension();
            isInit = true;
        } catch (Exception e) {
            throw new RuntimeException("加载定制化实现类异常:" + extensionPackageName, e);
        }
    }

    private static void buildDefaultExtension() {
        if (null == approvedTypeDefaultParamBuilder) {
            approvedTypeDefaultParamBuilder = new ApprovedTypeDefaultParamBuilderImpl();
        }
        if (null == createdTypeDefaultParamBuilder) {
            createdTypeDefaultParamBuilder = new CreatedTypeDefaultParamBuilderImpl();
        }
        if (null == modifiedTypeDefaultParamBuilder) {
            modifiedTypeDefaultParamBuilder = new ModifiedTypeDefaultParamBuilderImpl();
        }
        if (null == opRightValConvertor) {
            opRightValConvertor = new OpRightValConvertorImpl();
        }
    }

    public static IApprovedTypeDefaultParamBuilder getApprovedTypeDefaultParamBuilder() {
        return approvedTypeDefaultParamBuilder;
    }

    public static ICreatedTypeDefaultParamBuilder getCreatedTypeDefaultParamBuilder() {
        return createdTypeDefaultParamBuilder;
    }

    public static IModifiedTypeDefaultParamBuilder getModifiedTypeDefaultParamBuilder() {
        return modifiedTypeDefaultParamBuilder;
    }

    public static IOtherWhereConditionAdder getOtherWhereConditionAdder() {
        return otherWhereConditionAdder;
    }

    public static IOpRightValConvertor getOpRightValConvertor() {
        if (null == opRightValConvertor) {
            opRightValConvertor = new OpRightValConvertorImpl();
        }
        return opRightValConvertor;
    }

    public static DbType getDbType() {
        return DB_TYPE;
    }

    public static boolean isIsInit() {
        return isInit;
    }
}
