package com.digiwin.monitor.scan.sdk.enumerate;

/**
 * @description: join类型
 * @author: liunansheng
 * @date: 2021/11/25 16:03
 */
public enum JoinType {
    INNER("INNER","inner join"),
    LEFT("LEFT","left join"),
    RIGHT("RIGHT","right join")
    ;

    private String joinType;

    private String joinSql;

    private JoinType(String joinType, String joinSql) {
        this.joinType = joinType;
        this.joinSql = joinSql;
    }

    public static String getJoinSql(String joinType) {
        for (JoinType type : JoinType.values()) {
            if (type.joinType.equalsIgnoreCase(joinType)) {
                return type.joinSql;
            }
        }
        throw new RuntimeException("不支持的join类型");
    }
}
