package com.digiwin.monitor.scan.sdk.extension;

import com.digiwin.monitor.scan.sdk.parse.builder.Criterion;

import java.util.List;

/**
 * @description: 修改类型侦测处理默认条件
 * @author: liunansheng
 * @date: 2022/2/18 15:54
 */
public interface IApprovedTypeDefaultParamBuilder {
    /**
     * 审核类型侦测拼接默认条件:  已审核 + 审核时间在starTime与endTime范围
     * @param approveDateColumnList 审核时间字段名
     * @param approveStatusColumnList 审核状态字段名
     * @param startTime 开始时间
     * @param endTime 结束时间
     * @param tableName 表名
     * @param alias 别名
     * @return
     */
    List<Criterion> build(List<String> approveDateColumnList, List<String> approveStatusColumnList,
                          String startTime, String endTime, String tableName, String alias);

}
