package com.digiwin.monitor.scan.sdk.extension.impl;

import com.digiwin.monitor.scan.sdk.enumerate.ConditionValueType;
import com.digiwin.monitor.scan.sdk.enumerate.OpType;
import com.digiwin.monitor.scan.sdk.parse.builder.Criterion;
import com.digiwin.monitor.scan.sdk.util.CollectionUtil;

import java.util.ArrayList;
import java.util.List;

/**
 * @description: 默认字段时间字段处理
 * @author: liunansheng
 * @date: 2022/2/24 9:35
 */
public abstract class BaseDefaultTimeParamBuilder {
    /**
     * 拼接三个字段或字符串函数模板
     */
    public static final String CONCAT_THREE_FUNC_FORMAT = "CONCAT(CONCAT(%s,%s),%s)";


    public List<Criterion> buildTimeCriterion(List<String> dateColumnList, String startTime, String endTime, String tableName, String alias) {
        List<Criterion> criterionList = new ArrayList<>();
        if (CollectionUtil.isNotEmpty(dateColumnList)) {
            /** 此处拼接时间条件 */
            startTime = startTime.substring(0, 19);
            endTime = endTime.substring(0, 19);
            String left = dateColumnList.get(0);
            if (2 == dateColumnList.size()) {
                left = String.format(CONCAT_THREE_FUNC_FORMAT, dateColumnList.get(0), "' '" ,dateColumnList.get(1));
            }
            criterionList.add(new Criterion(left, OpType.GREATER_EQUAL.toString(), startTime, ConditionValueType.DATE_TIME.toString(), tableName, alias));
            criterionList.add(new Criterion(left, OpType.LESS_EQUAL.toString(), endTime, ConditionValueType.DATE_TIME.toString(), tableName, alias));
        }
        return  criterionList;
    }
}
