package com.digiwin.monitor.scan.sdk.extension.impl;

import com.digiwin.monitor.scan.sdk.enumerate.ConditionValueType;
import com.digiwin.monitor.scan.sdk.enumerate.OpType;
import com.digiwin.monitor.scan.sdk.extension.ICreatedTypeDefaultParamBuilder;
import com.digiwin.monitor.scan.sdk.parse.builder.Criterion;
import com.digiwin.monitor.scan.sdk.util.CollectionUtil;

import java.util.ArrayList;
import java.util.List;

/**
 * @description: 创建类型侦测处理默认条件
 * @author: liunansheng
 * @date: 2022/2/18 15:54
 */
public class CreatedTypeDefaultParamBuilderImpl extends BaseDefaultTimeParamBuilder implements ICreatedTypeDefaultParamBuilder {


    @Override
    public List<Criterion> build(List<String> createDateColumnList, List<String> approveStatusColumnList,
                                 String startTime, String endTime, String tableName, String alias) {
        if (CollectionUtil.isEmpty(approveStatusColumnList) && CollectionUtil.isEmpty(createDateColumnList)) {
            return null;
        }
        List<Criterion> criterionList = new ArrayList<>();
        if (CollectionUtil.isNotEmpty(approveStatusColumnList)) {
            for (String statusColumn : approveStatusColumnList) {
                /** 此处拼接未审核条件 */
                criterionList.add(new Criterion(statusColumn, OpType.EQUAL.toString(), "N", ConditionValueType.STRING.toString(), tableName, alias));
            }
        }
        if (CollectionUtil.isNotEmpty(createDateColumnList)) {
            /** 此处拼接创建时间条件 */
            criterionList.addAll(super.buildTimeCriterion(createDateColumnList, startTime, endTime, tableName, alias));
        }
        return criterionList;
    }
}
