package com.digiwin.monitor.scan.sdk.extension.impl;

import com.digiwin.monitor.scan.sdk.enumerate.ConditionValueType;
import com.digiwin.monitor.scan.sdk.extension.IOpRightValConvertor;

/**
 * @description: 运算符右边值处理
 * @author: liunansheng
 * @date: 2022/2/18 16:39
 */
public class OpRightValConvertorImpl implements IOpRightValConvertor {

    /**
     * 运算符右边值处理
     *  比如运算符为 EQUAL,左边字段为name : 方法返回 'ab'得到的sql为 name = 'ab';方法返回 1 得到sql为 name = 1
     * @param valueType 值类型
     * @param value  值
     * @param tableName 主表名称
     * @param columnName 字段名
     * @return
     */
    @Override
    public String convertVal(String valueType, String value, String tableName, String columnName) {

        if (ConditionValueType.STRING.toString().equalsIgnoreCase(valueType)) {
            return " '" + value + "' ";
        } else if (ConditionValueType.INT.toString().equalsIgnoreCase(valueType)
                || ConditionValueType.DECIMAL.toString().equalsIgnoreCase(valueType)
                || ConditionValueType.COLUMN.toString().equalsIgnoreCase(valueType)
                || ConditionValueType.BOOLEAN.toString().equalsIgnoreCase(valueType)) {
            return value;
        } else if (ConditionValueType.DATE_TIME.toString().equalsIgnoreCase(valueType)
                || ConditionValueType.DATE.toString().equalsIgnoreCase(valueType)
                || ConditionValueType.TIME.toString().equalsIgnoreCase(valueType)) {
            return " '" + value + "' ";
        }
        return " '" + value + "' ";
    }
}
