package com.digiwin.monitor.scan.sdk.parse;

import com.digiwin.monitor.scan.sdk.enumerate.ActionParamType;
import com.digiwin.monitor.scan.sdk.pojo.request.ActionParam;
import com.digiwin.monitor.scan.sdk.util.CollectionUtil;
import com.digiwin.monitor.scan.sdk.util.DateUtil;
import com.digiwin.monitor.scan.sdk.util.StringUtil;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @description: 返回值转换
 * @author: liunansheng
 * @date: 2021/11/25 13:07
 */
public class RespParser {
    //支持的函数
    private static Map<String, ActionParamFunc> FUNC_MAP = new HashMap<>();

    static {
        //FIXME 可根据需要扩展函数
        FUNC_MAP.put("CONCAT", param -> {
            if (CollectionUtil.isEmpty(param)) {
                return null;
            }
            return CollectionUtil.join(param,"");
        });
    }

    /**
     * 转换返回值
     * @param records
     * @param actionParams
     * @return
     */
    public static List<Map<String,Object>> convertResp(List<Map<String,Object>> records, List<ActionParam> actionParams){
        if (records == null) {
            return null;
        }
        List<Map<String,Object>> result = new ArrayList<>();
        for (Map<String,Object> record : records) {
            Map<String,Object> returnRecord = new HashMap<>();
            for (ActionParam actionParam : actionParams) {
                Object val = parseVal(actionParam, record);
                returnRecord.put(actionParam.getName(), val);
            }
            result.add(returnRecord);
        }
        return result;
    }

    /**
     * 解析返回值
     * @param actionParam
     * @param record
     * @return
     */
    private static Object parseVal(ActionParam actionParam, Map<String,Object> record){
        if (ActionParamType.CONSTANT.toString().equalsIgnoreCase(actionParam.getType())) {
            return actionParam.getValue();
        } else if (ActionParamType.COLUMN.toString().equalsIgnoreCase(actionParam.getType())) {
            Object val = record.get(actionParam.getValue());
            if (null == val) {
                /**actionParam.value配了别名的异常场景*/
                int index = actionParam.getValue().indexOf(".");
                if (index > 0) {
                    val = record.get(actionParam.getValue().substring(index + 1));
                }
            }
            if (DateUtil.isDate(val)) {
                /**时间格式化*/
                return DateUtil.dateFormat(val);
            }
            return val;
        } else if (ActionParamType.FUNCTION.toString().equalsIgnoreCase(actionParam.getType())) {
            return getFunctionVal(actionParam.getFunc_name(), actionParam.getFunction_params(), record);
        }
        throw new RuntimeException("未支持的action_param_type");
    }

    /**
     * 获取函数类型值
     * @param functionName
     * @param funcParams
     * @param record
     * @return
     */
    private static Object getFunctionVal(String functionName, List<ActionParam> funcParams, Map<String,Object> record) {
        if (CollectionUtil.isEmpty(funcParams)) {
            return doFunction(functionName,null);
        }
        List<Object> paramValList = new ArrayList<>();
        for (ActionParam actionParam : funcParams) {
            paramValList.add(parseVal(actionParam, record));
        }
        return doFunction(functionName, paramValList);
    }

    /**
     * 执行函数
     * @param functionName
     * @param paramList
     * @return
     */
    private static Object doFunction(String functionName, List<Object> paramList) {
        ActionParamFunc func = FUNC_MAP.get(functionName);
        if (func == null) {
            throw new RuntimeException("未支持的函数：" + functionName);
        }
        return func.call(paramList);
    }

    private interface ActionParamFunc {
        Object call(List<Object> param);
    }
}
