package com.digiwin.monitor.scan.sdk.parse;

import com.digiwin.monitor.scan.sdk.DataChangeGetExtensionContext;
import com.digiwin.monitor.scan.sdk.enumerate.ConditionType;
import com.digiwin.monitor.scan.sdk.extension.IOtherWhereConditionAdder;
import com.digiwin.monitor.scan.sdk.parse.builder.*;
import com.digiwin.monitor.scan.sdk.pojo.request.*;
import com.digiwin.monitor.scan.sdk.util.CollectionUtil;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

/**
 * @description: 根据规则解析sql
 * @author: liunansheng
 * @date: 2021/11/25 11:30
 */
public class SqlParser {

    public static String parse(DataChangeGetRequest requestDto, Rule rule) {
        boolean isDistinct = "DISTINCT".equalsIgnoreCase(rule.getSelect_type());
        /** 返回列 */
        List<SelectColumn> returnColumnList = convertSelectColumn(rule.getReturn_columns());
        /** join */
        List<JoinBuilder> joinBuilderList = convertJoin(rule.getJoin_params());
        List<Criterion> whereCriterionList = new ArrayList<>();
        if (rule.getDynamic_condition() != null && !rule.getDynamic_condition().isEmpty()) {
            /** where */
            Criterion dynamicCriterion = conditionCovertToCriterion(rule.getDynamic_condition(), rule.getTable(), rule.getAlias());
            whereCriterionList.add(dynamicCriterion);
        }
        /** default参数 */
        List<Criterion> defaultCriterionList = DefaultParamConverter.buildDefaultCondition(rule, requestDto.getDatetime_s(), requestDto.getDatetime_e());
        if (CollectionUtil.isNotEmpty(defaultCriterionList)) {
            whereCriterionList.addAll(defaultCriterionList);
        }
        /**应用固定添加的其他条件*/
        IOtherWhereConditionAdder otherWhereConditionAdder = DataChangeGetExtensionContext.getOtherWhereConditionAdder();
        if (null != otherWhereConditionAdder) {
            List<Criterion> otherCondition = otherWhereConditionAdder.add(requestDto, rule.getTable(), rule.getAlias());
            if (CollectionUtil.isNotEmpty(otherCondition)) {
                whereCriterionList.addAll(otherCondition);
            }
        }
        /** 构建sql */
        SqlBuilder sqlBuilder = new SqlBuilder(isDistinct, returnColumnList, rule.getTable(), rule.getAlias(), joinBuilderList, whereCriterionList);
        return sqlBuilder.toString();
    }

    /**
     * 返回列转换
     * @param returnColumnList
     * @return
     */
    private static List<SelectColumn> convertSelectColumn(List<ReturnColumn> returnColumnList) {
        List<SelectColumn> selectColumnList = new ArrayList<>();
        for (ReturnColumn returnColumn : returnColumnList) {
            selectColumnList.add(new SelectColumn(returnColumn.getName(), returnColumn.getAlias()));
        }
        return selectColumnList;
    }

    /**
     * join转换
     * @param joinParams
     * @return
     */
    private static List<JoinBuilder> convertJoin(List<JoinParam> joinParams) {
        if (CollectionUtil.isEmpty(joinParams)) {
            return null;
        }
        /** join多个表时，按设置顺序排序 */
        if (joinParams.size() > 1) {
            joinParams.sort(new Comparator<JoinParam>() {
                @Override
                public int compare(JoinParam o1, JoinParam o2) {
                    return o1.getSeq().compareTo(o2.getSeq());
                }
            });
        }
        List<JoinBuilder> joinBuilderList = new ArrayList<>();
        for (JoinParam joinParam : joinParams) {
            Criterion criterion = conditionCovertToCriterion(joinParam.getCondition(), joinParam.getTable(), joinParam.getAlias());
            JoinBuilder joinBuilder = new JoinBuilder(joinParam.getTable(), joinParam.getAlias(), joinParam.getType(), criterion);
            joinBuilderList.add(joinBuilder);
        }
        return joinBuilderList;
    }

    /**
     * condition转换未criterion
     * @param condition
     * @param table
     * @return
     */
    private static Criterion conditionCovertToCriterion(Condition condition, String table, String alias) {
        if (ConditionType.SINGLE.toString().equals(condition.getType())) {
            return new Criterion(condition.getLeft(), condition.getOp(), condition.getRight(), condition.getRight_value_type(), table, alias);
        } else if (ConditionType.AND_GROUP.toString().equals(condition.getType())
            || ConditionType.OR_GROUP.toString().equals(condition.getType())) {
            List<Criterion> criterionList = new ArrayList<>();
            for (Condition item : condition.getItems()) {
                Criterion one = conditionCovertToCriterion(item, table, alias);
                criterionList.add(one);
            }
            GroupCriterion groupCriterion = new GroupCriterion(condition.getType(), criterionList);
            return new Criterion(groupCriterion);
        }
        throw new RuntimeException("未支持的conditionType：" + condition.getType());
    }
}
