package com.digiwin.monitor.scan.sdk.parse.builder;

import com.digiwin.monitor.scan.sdk.parse.builder.op.OperatorHandlerHolder;
import com.digiwin.monitor.scan.sdk.util.StringUtil;

/**
 * @description: sql条件对象
 * @author: liunansheng
 * @date: 2021/11/24 14:24
 */
public class Criterion {
    /**
     * 表名
     */
    private String table;
    /**
     * 别名
     */
    private String alias;
    /**
     * sql条件列名
     */
    private String column;
    /**
     * 运算符
     */
    private String op;
    /**
     * sql条件值
     */
    private String value;
    /**
     * 值类型
     */
    private String valueType;
    /**
     * AND_GROUP或OR_GROUP ，条件集合
     */
    private GroupCriterion groupCriterion;

    public Criterion(String column, String op, String value, String valueType, String table, String alias) {
        this.column = column;
        this.op = op;
        this.value = value;
        this.valueType = valueType;
        this.table = table;
        this.alias = alias;
    }

    public Criterion(GroupCriterion groupCriterion) {
        this.groupCriterion = groupCriterion;
    }

    public Criterion() {
    }

    @Override
    public String toString() {
        if (groupCriterion != null) {
            //如果groupCriterion存在，说明是一组条件
            return groupCriterion.toString();
        }
        String column = this.column;
        if (StringUtil.isNotBlank(this.alias) && !StringUtil.contains(this.column, ".")) {
            column = this.alias + "." + this.column;
        }
        return OperatorHandlerHolder.handle(this.op, this.value, this.valueType, this.table, column);
    }

    public String getColumn() {
        return column;
    }

    public void setColumn(String column) {
        this.column = column;
    }

    public String getOp() {
        return op;
    }

    public void setOp(String op) {
        this.op = op;
    }

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getValueType() {
        return valueType;
    }

    public void setValueType(String valueType) {
        this.valueType = valueType;
    }

    public GroupCriterion getGroupCriterion() {
        return groupCriterion;
    }

    public void setGroupCriterion(GroupCriterion groupCriterion) {
        this.groupCriterion = groupCriterion;
    }

    public String getTable() {
        return table;
    }

    public void setTable(String table) {
        this.table = table;
    }
}
