package com.digiwin.monitor.scan.sdk.parse.builder.op.impl;


import com.digiwin.monitor.scan.sdk.enumerate.OpType;
import com.digiwin.monitor.scan.sdk.parse.builder.op.IOperatorHandler;
import com.digiwin.monitor.scan.sdk.util.CollectionUtil;
import com.digiwin.monitor.scan.sdk.util.JsonUtil;

import java.util.ArrayList;
import java.util.List;

/**
 * @description:
 * @author: liunansheng
 * @date: 2021/11/24 15:39
 */
public class InHandler extends IOperatorHandler {

    @Override
    public String handle(String value, String valueType, String tableName, String columnName) {
        List<String> valueArray = JsonUtil.parseArray(value, String.class);
        List<String> convertRsList = new ArrayList<>();
        for (String one : valueArray) {
            convertRsList.add(super.convertVal(valueType, one, tableName, columnName));
        }
        return " " + columnName +" in (" + CollectionUtil.join(convertRsList, ",") + ") ";
    }

    @Override
    public String getOpType() {
        return OpType.IN.toString();
    }
}
