package com.digiwin.monitor.scan.sdk.pojo.request;

import com.digiwin.monitor.scan.sdk.enumerate.ConditionValueType;
import com.digiwin.monitor.scan.sdk.enumerate.OpType;
import com.digiwin.monitor.scan.sdk.util.CollectionUtil;
import com.digiwin.monitor.scan.sdk.util.StringUtil;

import java.util.List;

/**
 * @author zhangzhi@digiwin.com
 * @date 2021/11/8
 */
public class Condition {
    /**
     * 条件类型:SINGLE 单个表达式，AND_GROUP 表达式集合为and关系,OR_GROUP 表达式集合为or关系
     */
    private String type;
    /**
     * 运算符左边值
     */
    private String left;
    /**
     * 运算符左边值类型
     */
    private String left_value_type;
    /**
     * 运算符类型：{@link OpType}
     */
    private String op;
    /**
     * 运算符右边值
     */
    private String right;
    /**
     * 运算符右边值类型：{@link ConditionValueType}
     */
    private String right_value_type;

    /**
     * AND_GROUP 或 OR_GROUP时，多个条件集合
     */
    private List<Condition> items;

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getLeft() {
        return left;
    }

    public void setLeft(String left) {
        this.left = left;
    }

    public String getLeft_value_type() {
        return left_value_type;
    }

    public void setLeft_value_type(String left_value_type) {
        this.left_value_type = left_value_type;
    }

    public String getOp() {
        return op;
    }

    public void setOp(String op) {
        this.op = op;
    }

    public String getRight() {
        return right;
    }

    public void setRight(String right) {
        this.right = right;
    }

    public String getRight_value_type() {
        return right_value_type;
    }

    public void setRight_value_type(String right_value_type) {
        this.right_value_type = right_value_type;
    }

    public List<Condition> getItems() {
        return items;
    }

    public void setItems(List<Condition> items) {
        this.items = items;
    }


    @Override
    public String toString() {
        return "Condition{" +
                "type='" + type + '\'' +
                ", left='" + left + '\'' +
                ", left_value_type='" + left_value_type + '\'' +
                ", op='" + op + '\'' +
                ", right='" + right + '\'' +
                ", right_value_type='" + right_value_type + '\'' +
                ", items=" + items +
                '}';
    }

    public boolean isEmpty() {
        return StringUtil.isBlank(this.type)
                && StringUtil.isBlank(this.left)
                && CollectionUtil.isEmpty(items);
    }
}
