package com.digiwin.monitor.scan.sdk.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;

/**
 * collection集合类操作
 *
 * @author zhangzhi@digiwin.com
 * @date 2020/7/17
 */
public final class CollectionUtil {
    private CollectionUtil() {
    }
    public static boolean isEmpty(Collection collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isEmpty(Object[] arrays) {
        return arrays == null || arrays.length == 0;
    }

    public static boolean isEmpty(Map map) {
        return map == null || map.isEmpty();
    }

    public static boolean isNotEmpty(Collection collection) {
        return collection != null && !collection.isEmpty();
    }

    public static boolean isNotEmpty(Object[] arrays) {
        return arrays != null && arrays.length > 0;
    }

    public static boolean isNotEmpty(Map map) {
        return map != null && !map.isEmpty();
    }

    public static String join(Collection collection, String separator) {
        if (collection == null) {
            return null;
        }
        if (collection.size() == 0) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        Iterator iterator = collection.iterator();
        for (int i = 0; i < collection.size(); i++) {
            Object one = iterator.next();
            if (i > 0) {
                buf.append(separator);
            }
            buf.append(Objects.toString(one, ""));
        }
        return buf.toString();
    }
}
