package com.digiwin.monitor.scan.sdk.util;

import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;

/**
 * @description:
 * @author: liunansheng
 * @date: 2022/2/23 10:33
 */
public class DateUtil {

    private static final DateTimeFormatter YYYYMMDD_HHMMSS_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

    public static boolean isDate(Object val) {
        if (val == null) {
            return false;
        }
        return val instanceof Date
                || val instanceof LocalDateTime
                || val instanceof LocalDate;
    }

    public static String dateFormat(Object date) {
        if (date == null) {
            return null;
        }
        if (date instanceof Date) {
            String formatStr = "yyyy-MM-dd HH:mm:ss";
            if (date instanceof java.sql.Date) {
                formatStr = "yyyy-MM-dd";
            } else if (date instanceof java.sql.Time){
                formatStr = "HH:mm:ss";
            }
            SimpleDateFormat format = new SimpleDateFormat(formatStr);
            return format.format((Date)date);
        } else if (date instanceof LocalDateTime) {
            return ((LocalDateTime) date).format(YYYYMMDD_HHMMSS_FORMATTER);
        } else if (date instanceof LocalDate) {
            return ((LocalDate) date).toString();
        }
        return date.toString();
    }
}
