package com.digiwin.monitor.scan.sdk.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.List;

/**
 * JSON处理工具类
 * @date 2020/07/17
 */
public final class JsonUtil {
    private JsonUtil() {
    }
    /**
     * json串转换成对象,顺序按照原始顺序输出
     *
     * @param jsonText
     * @return T
     */
    public static <T> List<T> parseArray(String jsonText, Class<T> tClass) {
        Type type =  TypeToken.getParameterized(List.class, tClass).getType();
        return new Gson().fromJson(jsonText, type);
    }

    /**
     * json序列化
     * @param obj
     * @return
     */
    public static String toJsonString(Object obj, boolean... serializeNulls) {
        if (obj == null) {
            return null;
        }
        if (null != serializeNulls && serializeNulls.length > 0 && serializeNulls[0]) {
            return new GsonBuilder().serializeNulls().create().toJson(obj);
        }
        return new Gson().toJson(obj);
    }

    /**
     * json反序列化
     * @param json
     * @param tClass
     * @return
     */
    public static <T> T parseObject(String json, Class<T> tClass) {
        return new Gson().fromJson(json, tClass);
    }

}
