package com.digiwin.monitor.scan.sdk.util;

/**
 * String操作工具类
 *
 * @author zhangzhi@digiwin.com
 * @date 2020/7/17
 */
public final class StringUtil {
    private StringUtil() {
    }

    public static boolean isBlank(String string) {
        return nullToEmpty(string).trim().isEmpty();
    }

    public static boolean isNotBlank(String string) {
        return !isBlank(string);
    }

    public static String trimToEmpty(String string) {
        return string == null ? "" : string.trim();
    }

    public static String nullToEmpty(String string) {
        return string == null ? "" : string;
    }

    public static boolean isEmpty(String string) {
        return nullToEmpty(string).isEmpty();
    }

    public static boolean contains(String data, String serach) {
        if (data == null || serach == null) {
            return false;
        }
        return data.indexOf(serach) > -1;
    }

    public static String replace(final String text, final String searchString, final String replacement) {
        if (isEmpty(text) || isEmpty(searchString) || replacement == null) {
            return text;
        }
        int max = -1;
        String searchText = text;
        int start = 0;
        int end = searchText.indexOf(searchString, start);
        if (end == -1) {
            return text;
        }
        final int replLength = searchString.length();
        int increase = replacement.length() - replLength;
        increase = increase < 0 ? 0 : increase;
        increase *= max < 0 ? 16 : max > 64 ? 64 : max;
        final StringBuilder buf = new StringBuilder(text.length() + increase);
        while (end != -1) {
            buf.append(text, start, end).append(replacement);
            start = end + replLength;
            if (--max == 0) {
                break;
            }
            end = searchText.indexOf(searchString, start);
        }
        buf.append(text, start, text.length());
        return buf.toString();
    }
}
