/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap;

import com.sun.jndi.ldap.LdapClient;
import com.sun.jndi.ldap.LdapCtx;
import com.sun.jndi.ldap.LdapEntry;
import com.sun.jndi.ldap.LdapName;
import com.sun.jndi.ldap.LdapReferralContext;
import com.sun.jndi.ldap.LdapReferralException;
import com.sun.jndi.ldap.LdapResult;
import com.sun.jndi.ldap.ReferralEnumeration;
import com.sun.jndi.toolkit.ctx.Continuation;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.naming.LimitExceededException;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.PartialResultException;
import javax.naming.directory.Attributes;
import javax.naming.ldap.Control;

abstract class AbstractLdapNamingEnumeration<T extends NameClassPair>
implements NamingEnumeration<T>,
ReferralEnumeration<T> {
    protected Name listArg;
    private boolean cleaned = false;
    private LdapResult res;
    private LdapClient enumClnt;
    private Continuation cont;
    private Vector<LdapEntry> entries = null;
    private int limit = 0;
    private int posn = 0;
    protected LdapCtx homeCtx;
    private LdapReferralException refEx = null;
    private NamingException errEx = null;
    private boolean more = true;
    private boolean hasMoreCalled = false;

    AbstractLdapNamingEnumeration(LdapCtx homeCtx, LdapResult answer, Name listArg, Continuation cont) throws NamingException {
        if (answer.status != 0 && answer.status != 4 && answer.status != 3 && answer.status != 11 && answer.status != 10 && answer.status != 9) {
            NamingException e = new NamingException(LdapClient.getErrorMessage(answer.status, answer.errorMessage));
            throw cont.fillInException(e);
        }
        this.res = answer;
        this.entries = answer.entries;
        this.limit = this.entries == null ? 0 : this.entries.size();
        this.listArg = listArg;
        this.cont = cont;
        if (answer.refEx != null) {
            this.refEx = answer.refEx;
        }
        this.homeCtx = homeCtx;
        homeCtx.incEnumCount();
        this.enumClnt = homeCtx.clnt;
    }

    @Override
    public final T nextElement() {
        try {
            return (T)this.next();
        }
        catch (NamingException e) {
            this.cleanup();
            return null;
        }
    }

    @Override
    public final boolean hasMoreElements() {
        try {
            return this.hasMore();
        }
        catch (NamingException e) {
            this.cleanup();
            return false;
        }
    }

    private void getNextBatch() throws NamingException {
        this.res = this.homeCtx.getSearchReply(this.enumClnt, this.res);
        if (this.res == null) {
            this.posn = 0;
            this.limit = 0;
            return;
        }
        this.entries = this.res.entries;
        this.limit = this.entries == null ? 0 : this.entries.size();
        this.posn = 0;
        if (this.res.status != 0 || this.res.status == 0 && this.res.referrals != null) {
            try {
                this.homeCtx.processReturnCode(this.res, this.listArg);
            }
            catch (LimitExceededException | PartialResultException e) {
                this.setNamingException(e);
            }
        }
        if (this.res.refEx != null) {
            this.refEx = this.refEx == null ? this.res.refEx : this.refEx.appendUnprocessedReferrals(this.res.refEx);
            this.res.refEx = null;
        }
        if (this.res.resControls != null) {
            this.homeCtx.respCtls = this.res.resControls;
        }
    }

    @Override
    public final boolean hasMore() throws NamingException {
        if (this.hasMoreCalled) {
            return this.more;
        }
        this.hasMoreCalled = true;
        if (!this.more) {
            return false;
        }
        this.more = this.hasMoreImpl();
        return this.more;
    }

    @Override
    public final T next() throws NamingException {
        if (!this.hasMoreCalled) {
            this.hasMore();
        }
        this.hasMoreCalled = false;
        return this.nextImpl();
    }

    private boolean hasMoreImpl() throws NamingException {
        if (this.posn == this.limit) {
            this.getNextBatch();
        }
        if (this.posn < this.limit) {
            return true;
        }
        try {
            return this.hasMoreReferrals();
        }
        catch (LdapReferralException | LimitExceededException | PartialResultException e) {
            this.cleanup();
            throw e;
        }
        catch (NamingException e) {
            this.cleanup();
            PartialResultException pre = new PartialResultException();
            pre.setRootCause(e);
            throw pre;
        }
    }

    private T nextImpl() throws NamingException {
        try {
            return this.nextAux();
        }
        catch (NamingException e) {
            this.cleanup();
            throw this.cont.fillInException(e);
        }
    }

    private T nextAux() throws NamingException {
        if (this.posn == this.limit) {
            this.getNextBatch();
        }
        if (this.posn >= this.limit) {
            this.cleanup();
            throw new NoSuchElementException("invalid enumeration handle");
        }
        LdapEntry result = this.entries.elementAt(this.posn++);
        return this.createItem(result.DN, result.attributes, result.respCtls);
    }

    protected final String getAtom(String dn) {
        try {
            LdapName parsed = new LdapName(dn);
            return parsed.get(parsed.size() - 1);
        }
        catch (NamingException e) {
            return dn;
        }
    }

    protected abstract T createItem(String var1, Attributes var2, Vector<Control> var3) throws NamingException;

    @Override
    public void appendUnprocessedReferrals(LdapReferralException ex) {
        this.refEx = this.refEx != null ? this.refEx.appendUnprocessedReferrals(ex) : ex.appendUnprocessedReferrals(this.refEx);
    }

    final void setNamingException(NamingException e) {
        this.errEx = e;
    }

    protected abstract AbstractLdapNamingEnumeration<? extends NameClassPair> getReferredResults(LdapReferralContext var1) throws NamingException;

    protected final boolean hasMoreReferrals() throws NamingException {
        if (this.refEx != null && (this.refEx.hasMoreReferrals() || this.refEx.hasMoreReferralExceptions())) {
            if (this.homeCtx.handleReferrals == 2) {
                throw (NamingException)this.refEx.fillInStackTrace();
            }
            while (true) {
                LdapReferralContext refCtx = (LdapReferralContext)this.refEx.getReferralContext(this.homeCtx.envprops, this.homeCtx.reqCtls);
                try {
                    this.update(this.getReferredResults(refCtx));
                }
                catch (LdapReferralException re) {
                    if (this.errEx == null) {
                        this.errEx = re.getNamingException();
                    }
                    this.refEx = re;
                    continue;
                }
                finally {
                    refCtx.close();
                    continue;
                }
                break;
            }
            return this.hasMoreImpl();
        }
        this.cleanup();
        if (this.errEx != null) {
            throw this.errEx;
        }
        return false;
    }

    protected void update(AbstractLdapNamingEnumeration<? extends NameClassPair> ne) {
        this.homeCtx.decEnumCount();
        this.homeCtx = ne.homeCtx;
        this.enumClnt = ne.enumClnt;
        ne.homeCtx = null;
        this.posn = ne.posn;
        this.limit = ne.limit;
        this.res = ne.res;
        this.entries = ne.entries;
        this.refEx = ne.refEx;
        this.listArg = ne.listArg;
    }

    protected final void finalize() {
        this.cleanup();
    }

    protected final void cleanup() {
        if (this.cleaned) {
            return;
        }
        if (this.enumClnt != null) {
            this.enumClnt.clearSearchReply(this.res, this.homeCtx.reqCtls);
        }
        this.enumClnt = null;
        this.cleaned = true;
        if (this.homeCtx != null) {
            this.homeCtx.decEnumCount();
            this.homeCtx = null;
        }
    }

    @Override
    public final void close() {
        this.cleanup();
    }
}

